% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsum_TOST.R
\name{tsum_TOST}
\alias{tsum_TOST}
\title{TOSTt with Summary Statistics}
\usage{
tsum_TOST(
  m1,
  sd1,
  n1,
  m2 = NULL,
  sd2 = NULL,
  n2 = NULL,
  r12 = NULL,
  hypothesis = c("EQU", "MET"),
  paired = FALSE,
  var.equal = FALSE,
  eqb,
  low_eqbound,
  high_eqbound,
  mu = 0,
  eqbound_type = c("raw", "SMD"),
  alpha = 0.05,
  bias_correction = TRUE,
  rm_correction = FALSE,
  glass = NULL,
  smd_ci = c("nct", "goulet", "t", "z")
)
}
\arguments{
\item{m1}{mean of group 1}

\item{sd1}{standard deviation of group 1}

\item{n1}{sample size in group 1}

\item{m2}{mean of group 2}

\item{sd2}{standard deviation of group 2}

\item{n2}{sample size in group 2}

\item{r12}{correlation of dependent variable between group 1 and group 2}

\item{hypothesis}{'EQU' for equivalence (default), or 'MET' for minimal effects test, the alternative hypothesis.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{eqb}{Equivalence bound. Can provide 1 value (negative value is taken as the lower bound) or 2 specific values that represent the upper and lower equivalence bounds.}

\item{low_eqbound}{lower equivalence bounds (deprecated).}

\item{high_eqbound}{upper equivalence bounds (deprecated).}

\item{mu}{a number indicating the true value of the mean for the two tailed test (or difference in means if you are performing a two sample test).}

\item{eqbound_type}{Type of equivalence bound. Can be set to "SMD" for standardized mean difference (i.e., Cohen's d) or  "raw" for the mean difference. Default is "raw". Raw is strongly recommended as SMD bounds will produce biased results.}

\item{alpha}{alpha level (default = 0.05)}

\item{bias_correction}{Apply Hedges' correction for bias (default is TRUE).}

\item{rm_correction}{Repeated measures correction to make standardized mean difference Cohen's d(rm). This only applies to repeated/paired samples. Default is FALSE.}

\item{glass}{A option to calculate Glass's delta as an alternative to Cohen's d type SMD. Default is NULL to not calculate Glass's delta, "glass1" will use the first group's SD as the denominator whereas "glass2" will use the 2nd group's SD.}

\item{smd_ci}{Method for calculating SMD confidence intervals. Methods include Goulet, noncentral t (nct), central t (t), and normal method (z).}
}
\value{
An S3 object of class
  \code{"TOSTt"} is returned containing the following slots:
\describe{
  \item{\code{"TOST"}}{A table of class \code{"data.frame"} containing two-tailed t-test and both one-tailed results.}
  \item{\code{"eqb"}}{A table of class \code{"data.frame"} containing equivalence bound settings.}
  \item{\code{"effsize"}}{ table of class \code{"data.frame"} containing effect size estimates}
  \item{\code{"hypothesis"}}{String stating the hypothesis being tested}
  \item{\code{"smd"}}{List containing the results of the standardized mean difference calculations (e.g., Cohen's d).Items include: d (estimate), dlow (lower CI bound), dhigh (upper CI bound), d_df (degrees of freedom for SMD), d_sigma (SE), d_lambda (non-centrality), J (bias correction), smd_label (type of SMD), d_denom (denominator calculation)}
  \item{\code{"alpha"}}{Alpha level set for the analysis.}
  \item{\code{"method"}}{Type of t-test.}
  \item{\code{"decision"}}{List included text regarding the decisions for statistical inference.}
}
}
\description{
A function for TOST with all types of t-tests from summary statistics.
}
\details{
For details on the calculations in this function see vignette("IntroTOSTt") & vignette("SMD_calcs").
}
\examples{
# example code
# One sample test
tsum_TOST(m1 = 0.55, n1 = 18, sd1 = 4, eqb  = 2)
}
\seealso{
Other TOST: 
\code{\link{simple_htest}()},
\code{\link{t_TOST}()}
}
\concept{TOST}
