% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcox_TOST.R
\name{wilcox_TOST}
\alias{wilcox_TOST}
\alias{wilcox_TOST.default}
\alias{wilcox_TOST.formula}
\title{TOST with Wilcoxon Signed Rank test}
\usage{
wilcox_TOST(
  x,
  ...,
  hypothesis = "EQU",
  paired = FALSE,
  low_eqbound,
  high_eqbound,
  alpha = 0.05
)

\method{wilcox_TOST}{default}(
  x,
  y = NULL,
  hypothesis = "EQU",
  paired = FALSE,
  low_eqbound,
  high_eqbound,
  alpha = 0.05,
  mu = 0,
  ...
)

\method{wilcox_TOST}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{hypothesis}{'EQU' for equivalence (default), or 'MET' for minimal effects test, the alternative hypothesis.}

\item{paired}{a logical indicating whether you want to calculate a paired test.}

\item{low_eqbound}{lower equivalence bounds.}

\item{high_eqbound}{upper equivalence bounds.}

\item{alpha}{alpha level (default = 0.05)}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{mu}{number indicating the value around which (a-)symmetry (for
one-sample or paired samples) or shift (for independent samples) is to be
estimated. See [stats::wilcox.test].}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs either 1 for a one-sample or paired test or a factor with two levels giving the corresponding groups. If lhs is of class "Pair" and rhs is 1, a paired test is done.}

\item{data}{an optional matrix or data frame (or similar: see model.frame) containing the variables in the formula formula. By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}
}
\value{
An S3 object of class
  \code{"TOSTnp"} is returned containing the following slots:
\describe{
  \item{\code{"TOST"}}{A table of class \code{"data.frame"} containing two-tailed wilcoxon signed rank test and both one-tailed results.}
  \item{\code{"eqb"}}{A table of class \code{"data.frame"} containing equivalence bound settings.}
  \item{\code{"effsize"}}{ table of class \code{"data.frame"} containing effect size estimates.}
  \item{\code{"hypothesis"}}{String stating the hypothesis being tested.}
  \item{\code{"smd"}}{List containing information on standardized effect size.}
  \item{\code{"alpha"}}{Alpha level set for the analysis.}
  \item{\code{"method"}}{Type of non-parametric test.}
  \item{\code{"decision"}}{List included text regarding the decisions for statistical inference.}
}
}
\description{
A function for TOST using the non-parametric methods of the Wilcoxon signed rank test. This function uses the normal approximation and applies continuity correction automatically.
}
\section{References}{

David F. Bauer (1972). Constructing confidence sets using rank statistics. Journal of the American Statistical Association 67, 687–690. doi: 10.1080/01621459.1972.10481279.

Myles Hollander and Douglas A. Wolfe (1973). Nonparametric Statistical Methods. New York: John Wiley & Sons. Pages 27–33 (one-sample), 68–75 (two-sample). Or second edition (1999).
}

