% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TNRS_metadata.R
\name{TNRS_metadata}
\alias{TNRS_metadata}
\title{Get TNRS metadata}
\usage{
TNRS_metadata(bibtex_file = NULL, skip_internet_check = FALSE)
}
\arguments{
\item{bibtex_file}{Optional output file for writing bibtex citations.}

\item{skip_internet_check}{Should the check for internet connectivity be skipped? Default is FALSE.}
}
\value{
List containing: (1) bibtex-formatted citation information, (2) information about TNRS data sources, and (3) TNRS version information.
}
\description{
Returns metadata on TNRS including version and citation information
}
\note{
This function provides citation information in bibtex format that can be used with reference manager software (e.g. Paperpile, Zotero). Please remember to cite both the sources and the TNRS, as the TNRS couldn't exist without these sources!

This function is a wrapper that returns the output of the functions TNRS_citations, TNRS_sources, and TNRS_version.
}
\examples{
{
  metadata <- TNRS_metadata()
}

}
