% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_Y.R
\name{make_Y}
\alias{make_Y}
\title{Returns the transformed p-values to be used in the TMTI, tTMTI or rtTMTI. Internal function.}
\usage{
make_Y(pvals, tau = NULL, K = NULL, log.p = TRUE)
}
\arguments{
\item{pvals}{A vector of p-values}

\item{tau}{A numeric between 0 and 1 indicating the truncation level.
Defaults to NULL}

\item{K}{An integer > 1 indicating the the truncation index. Defaults
to NULL}

\item{log.p}{Logical, indicating whether transformations are on log scale.
Defaults to TRUE.}
}
\value{
A vector, Y, of transformed p-values
}
\description{
Returns the transformed p-values to be used in the TMTI, tTMTI or rtTMTI. Internal function.
}
\examples{
## Simulate p-values
p <- runif(10)
make_Y(p)  # Normal Y transformation
make_Y(p, tau = 0.5) # Using only the p-values below .5
make_Y(p, K = 5) # Using only the five smallest p-values.
}
