% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMTI_CTP.R
\name{TMTI_CTP}
\alias{TMTI_CTP}
\title{A Closed Testing Procedure for the TMTI using an O(n^2) shortcut}
\usage{
TMTI_CTP(
  pvals,
  alpha = 0.05,
  B = 1000,
  gammaList = NULL,
  log.p = TRUE,
  tau = NULL,
  K = NULL,
  ...
)
}
\arguments{
\item{pvals}{A vector of p-values}

\item{alpha}{Level to perform each intersection test at. Defaults to 0.05}

\item{B}{Number of bootstrap replications if gamma needs to be approximated.
Not used if specifying a list of functions using the gammaList argument
or if length(pvals) <= 100. Defaults to 1000}

\item{gammaList}{A list of pre-specified gamma functions. If NULL, gamma
functions will be approximated via bootstrap, assuming independence. Defaults
to NULL.}

\item{log.p}{Logical, indicating whether to compute Y's on log-scale.
Defaults to TRUE}

\item{tau}{Numerical (in (0,1)); threshold to use in tTMTI. If set to NULL,
then either TMTI (default) or rtTMTI is used.}

\item{K}{Integer; Number of smallest p-values to use in rtTMTI. If se to NULL,
then either TMTI (default) or tTMTI is used.}

\item{...}{Additional arguments}
}
\value{
A data.frame containing:
* i: The sorted index of each p-value.
* p_adjust: The CTP adjusted p-value, controlling the FWER strongly.
* FirstAccept: The first level of the test tree at which the hypothesis could
not be rejected. NA if it is never rejected.
* Index: The original index of the unsorted p-value inputs.
}
\description{
A Closed Testing Procedure for the TMTI using an O(n^2) shortcut
}
\examples{
## Simulate some p-values
## The first 10 are from false hypotheses, the next 10 are from true
pvals <- c (
  rbeta(10, 1, 20),  ## Mean value of .05
  runif(10)
)
TMTI_CTP(pvals, earlyStop = TRUE)
}
