\name{tdmReadData}
\alias{tdmReadData}
\title{Read the data accoroding to the settings in \code{opts}.}
\usage{
  tdmReadData(opts)
}
\arguments{
  \item{opts}{list of options, we need here \itemize{ \item
  \code{filename}: string of filename in opts$dir.txt \item
  \code{filetest}: string of filename test data in
  opts$dir.txt (only if READ.TST=T) \item \code{READ.TXT}:
  [T] if =T: read from opts$filename, =F: load from .Rdata
  file \item \code{READ.CMD}: ["tdmReadCmd(filename,opts)"]
  string with a file-read-command with placeholder
  'filename' \item \code{READ.TST}: [F] if =T: read also
  test data from \code{filetest} \item \code{TST.COL}:
  ["TST.COL"] string, create a column with the name of this
  string in \code{dset}, which has 0 for training and 1 for
  test data \item \code{READ.NROW}: [-1] read only that
  many rows from opts$filename. -1 for 'read all rows'.  }}
}
\value{
  \code{dset}, a data frame with all data read
}
\description{
  Side effect: Data are saved on .Rdata file if
  opts$READ.TXT=TRUE (for quicker next-time access).
  Next-time access: Data are re-loaded from .Rdata if
  opts$READ.TXT=FALSE.
}
\details{
  When opts$READ.TST==T, the following things happen in
  \code{\link{tdmReadData}}: Data are read from
  opts$filename and from opts$filetest. Both data sets are
  bound together, with a new column opts$TST.COL having '0'
  for the data from opts$filename and having '1' for the
  data from opts$filetest.  The branch using opts$TST.COL
  is invoked either with umode="TST" in
  \code{\link{unbiasedRun}} or with opts$TST.kind="col" in
  \code{\link{tdmModCreateCVindex}}.
}
\note{
  If opts$READ.TXT=T and opts$READ.NROW>0, then only the
  first READ.NROW records are read from opts$filename and
  from opts$filetest.  Only the records read are saved to
  the .Rdata files. This means: when starting tdmReadData
  again with opts$READ.TXT=F, not more than these READ.NROW
  records can be retrieved from the relevant .Rdata files.
  To have again the full data sets on the .Rdata files, you
  need to invoke tdmReadData at least once with
  opts$READ.TXT=T and opts$READ.NROW==-1.  \cr If, on the
  other hand, the full data sets are stored in the .Rdata
  files, then opts$READ.TXT=F and opts$READ.NROW=<any
  value> allows to select a smaller subset of records from
  the .Rdata files.
}

