% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{permutation_test}
\alias{permutation_test}
\title{Statistical Inference for Topological Data Analysis}
\usage{
permutation_test(cloud1, cloud2, iterations, exponent = 1)
}
\arguments{
\item{cloud1}{point cloud represented as numeric matrix}

\item{cloud2}{point cloud represented as numeric matrix}

\item{iterations}{number of iterations for distribution in permutation test}

\item{exponent}{parameter `p` that returns Wasserstein-p metric}
}
\value{
list containing results of permutation test
}
\description{
Conducts a permutation test for nonparametric statistical inference
of persistent homology in topological data analysis.
}
\details{
The persistent homology of two point clouds are compared with the
Wasserstein metric (where Wasserstein-1 is also known as the Earth
Mover's Distance). However, the magnitude of the metric for a single pair
of point clouds is meaningless without a reference distribution. This
function uses a permutation test (permuting the points between the two
clouds) as a nonparametric hypothesis test for statistical inference.

For more details on permutation tests for statistical inference in
topological data analysis, see Robinson A, Turner K. Hypothesis
testing for topological data analysis. J Appl Comput Topology. 2017;
1(2): 241-261.<doi:10.1007/s41468-017-0008-7>
}
