% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{diagram_ksvm}
\alias{diagram_ksvm}
\title{Fit a support vector machine model where each training set instance is a persistence diagram.}
\usage{
diagram_ksvm(
  diagrams,
  cv = 1,
  dim,
  t = 1,
  sigma = 1,
  y,
  type = NULL,
  C = 1,
  nu = 0.2,
  epsilon = 0.1,
  prob.model = FALSE,
  class.weights = NULL,
  fit = TRUE,
  cache = 40,
  tol = 0.001,
  shrinking = TRUE,
  num_workers = parallelly::availableCores(omit = 1)
)
}
\arguments{
\item{diagrams}{a list of persistence diagrams which are either the output of a persistent homology calculation like \code{\link[TDA]{ripsDiag}}/\code{\link[TDAstats]{calculate_homology}}/\code{\link{PyH}}, or \code{\link{diagram_to_df}}.}

\item{cv}{a positive number at most the length of `diagrams` which determines the number of cross validation splits to be performed (default 1, aka no cross-validation).}

\item{dim}{a non-negative integer vector of homological dimensions in which the model is to be fit.}

\item{t}{a vector of positive numbers representing the grid of values for the scale of the persistence Fisher kernel, default 1.}

\item{sigma}{a vector of positive numbers representing the grid of values for the bandwidth of the Fisher information metric, default 1}

\item{y}{a response vector with one label for each persistence diagram. Must be either numeric or factor.}

\item{type}{a string representing the type of task to be performed.}

\item{C}{a number representing the cost of constraints violation (default 1) this is the 'C'-constant of the regularization term in the Lagrange formulation.}

\item{nu}{numeric parameter needed for nu-svc, one-svc and nu-svr. The `nu` parameter sets the upper bound on the training error and the lower bound on the fraction of data points to become Support Vector (default 0.2).}

\item{epsilon}{epsilon in the insensitive-loss function used for eps-svr, nu-svr and eps-bsvm (default 0.1).}

\item{prob.model}{if set to TRUE builds a model for calculating class probabilities or in case of regression, calculates the scaling parameter of the Laplacian distribution fitted on the residuals. Fitting is done on output data created by performing a 3-fold cross-validation on the training data. For details see references (default FALSE).}

\item{class.weights}{a named vector of weights for the different classes, used for asymmetric class sizes. Not all factor levels have to be supplied (default weight: 1). All components have to be named.}

\item{fit}{indicates whether the fitted values should be computed and included in the model or not (default TRUE).}

\item{cache}{cache memory in MB (default 40).}

\item{tol}{tolerance of termination criteria (default 0.001).}

\item{shrinking}{option whether to use the shrinking-heuristics (default TRUE).}

\item{num_workers}{the number of cores used for parallel computation, default is one less the number of cores on the machine.}
}
\value{
a list containing the elements

\describe{

\item{models}{the cross-validation results - a matrix storing the parameters for each model in the tuning grid and its mean cross-validation error over all splits.}

\item{best_model}{the output of \code{\link[kernlab]{ksvm}} run on the whole dataset with the optimal model parameters found during cross-validation. See the help page for \code{\link[kernlab]{ksvm}} for more details about this object.}

\item{diagrams}{the diagrams which were support vectors in the `best_model`. These are used for downstream prediction.}

\item{dim}{the input `dim` argument.}

\item{t}{the input `t` argument.}

\item{sigma}{the input `sigma` argument.}

}
}
\description{
Returns the output of kernlab's \code{\link{ksvm}} function on the Gram matrix of the list of persistence diagrams
in a particular dimension.
}
\details{
Cross validation is carried out in parallel, using a trick
noted in \doi{10.1007/s41468-017-0008-7} - since the persistence Fisher kernel can be
written as \eqn{d_{PF}(D_1,D_2)=exp(t*d_{FIM}(D_1,D_2))=exp(d_{FIM}(D_1,D_2))^t}, we can
store the Fisher information metric distance matrix for each sigma value in the parameter grid to avoid
recomputing distances, and cross validation is therefore performed in parallel. 
Note that the response parameter `y` must be a factor for classification - 
a character vector for instance will throw an error.
}
\examples{

if(require("TDA") & require("TDAstats"))
{
  # create four diagrams
  D1 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  D2 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  D3 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  D4 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  g <- list(D1,D2,D3,D4)

  # create response vector
  y <- as.factor(c("circle","sphere","circle","sphere"))

  # fit model without cross validation
  model_svm <- diagram_ksvm(diagrams = g,cv = 1,dim = c(0),
                            y = y,sigma = c(1),t = c(1),
                            num_workers = 2)
}
}
\references{
Murphy, K. "Machine learning: a probabilistic perspective." MIT press (2012).
}
\seealso{
\code{\link{predict_diagram_ksvm}} for predicting labels of new diagrams.
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
