% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries_eqdist.R
\name{fseqdist}
\alias{fseqdist}
\title{Multi-sample Energy Test of Equal Distributions}
\usage{
fseqdist(fslist, label, method = c("original", "disco"), mc.iter = 999)
}
\arguments{
\item{fslist}{a length-\eqn{N} list of functional summaries of persistent diagrams.}

\item{label}{a length-\eqn{N} vector of class labels.}

\item{method}{(case-sensitive) name of methods; one of \code{"original"} or \code{"disco"}.}

\item{mc.iter}{number of bootstrap replicates.}
}
\value{
a (list) object of S3 class \code{htest} containing:\describe{
  \item{method}{name of the test.}
  \item{statistic}{a test statistic.}
  \item{p.value}{\eqn{p}-value under \eqn{H_0} of equal distributions.}
}
}
\description{
Also known as \eqn{k}-sample problem, it tests whether multiple functional summaries 
are equally distributed or not via Energy statistics.
}
\examples{
\donttest{
# ---------------------------------------------------------------------------
#         Test for Equality of Distributions via Energy Statistics
#
# We will compare dim=0's top-5 landscape functions with 
# - Class 1 : 'iris' dataset with noise
# - Class 2 : samples from 'gen2holes()'
# - Class 3 : samples from 'gen2circles()'
# ---------------------------------------------------------------------------
## Generate Data and Diagram from VR Filtration
ndata     = 10
list_rips = list()
for (i in 1:ndata){
  dat1 = as.matrix(iris[,1:4]) + matrix(rnorm(150*4), ncol=4)
  dat2 = gen2holes(n=100, sd=1)$data
  dat3 = gen2circles(n=100, sd=1)$data
  
  list_rips[[i]] = diagRips(dat1, maxdim=1)
  list_rips[[i+ndata]] = diagRips(dat2, maxdim=1)
  list_rips[[i+(2*ndata)]] = diagRips(dat3, maxdim=1)
}

## Compute Persistence Landscapes from Each Diagram with k=5 Functions
list_land0 = list()
for (i in 1:(3*ndata)){
  list_land0[[i]] = diag2landscape(list_rips[[i]], dimension=0, k=5)
}

## Create Label and Run the Test with Different Options
list_lab = c(rep(1,ndata), rep(2,ndata), rep(3,ndata))
fseqdist(list_land0, list_lab, method="original")
fseqdist(list_land0, list_lab, method="disco")
}

}
\concept{summaries}
