% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{TCProfilePts}
\alias{TCProfilePts}
\title{Transect points from a origin through a point or with a bearing and to the opposite side.}
\usage{
TCProfilePts(
  TC_line,
  Through_point = NULL,
  bear = NULL,
  length = 200,
  step = 2
)
}
\arguments{
\item{TC_line}{origin of the transect}

\item{Through_point}{a point to pass through}

\item{bear}{the bearing}

\item{length}{the length of the transect in Km}

\item{step}{the spacing of the transect in Km}
}
\value{
spatial vector of transect profile points with distances in Km (negative for left hand side)
}
\description{
Transect points from a origin through a point or with a bearing and to the opposite side.
}
\examples{
require(terra)
TCi <- vect(cbind(c(154.1,154),c(-26.1,-26)),"lines",crs="epsg:4283") #track line segment
TCi$PRES <- 950
TCi$RMW <- 40
TCi$ISO_TIME <- "2022-10-04 20:00:00"
TCi$LON <- geom(TCi)[1,3]
TCi$LAT <- geom(TCi)[1,4]
TCi$STORM_SPD <- perim(TCi)/(3*3600) #m/s
TCi$thetaFm <- 90-returnBearing(TCi)
#Through_point <- isd[isd$OID==isdsi]
pp <- TCProfilePts(TC_line = TCi,Through_point=NULL,bear=TCi$thetaFm+90,length =100,step=10)
plot(pp,"radialdist",type="continuous")
lines(TCi,col=2)
}
