% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_7.R
\name{basic_tcga_query}
\alias{basic_tcga_query}
\title{TCGA Core Query Engine}
\usage{
basic_tcga_query(my_url)
}
\arguments{
\item{my_url}{string. Typically, a URL pointing to the cBioPortal API.}
}
\value{
data.frame including data retrieved from cBioPortal.
}
\description{
Core Function that queries the URL provided as argument (typically a cbioportal.org URL). 
The function halts until the content has been completely downloaded and returns a data frame.
}
\details{
This is a core function invoked by other functions in the package.
}
\examples{
my_url <- "http://www.cbioportal.org/webservice.do?cmd=getCancerStudies"
x <- TCGAretriever:::basic_tcga_query(my_url)
show_head(x, 5, 2) 

 
}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{intenal}
