\name{IRT.threshold}
\alias{IRT.threshold}
\alias{IRT.WrightMap}
\alias{IRT.WrightMap.IRT.threshold}
\alias{print.IRT.threshold}
%- Also NEED an '\alias' for EACH other topic documented here.

\title{
Thurstonian Thresholds and Wright Map for Item Response Models
}

\description{
The function \code{IRT.threshold} computes Thurstonian thresholds
for item response models. It is only based on fitted models
for which the \code{\link{IRT.irfprob}} does exist.

This function creates a Wright map and works as a wrapper to the
\code{\link[WrightMap:wrightMap]{wrightMap}} function in
the \pkg{WrightMap} package. Wright maps operate
on objects of class \code{\link{IRT.threshold}}.
}




\usage{
IRT.threshold(object, prob.lvl=.5)	
	
\method{print}{IRT.threshold}(x , \dots) 

IRT.WrightMap(object, \dots)

\method{IRT.WrightMap}{IRT.threshold}(object, label.items=NULL, \dots)
}



%- maybe also 'usage' for other objects documented here.

\arguments{
\item{object}{
Object of fitted models for which \code{\link{IRT.irfprob}} exists.
}
\item{prob.lvl}{Requested probability level of thresholds.}
\item{x}{Object of class \code{IRT.threshold}}
\item{label.items}{Vector of item labels}
\item{\dots}{
Further arguments to be passed.
}
}

%\item{type}{Type of person parameter estimate. \code{"PV"} (plausible values),
%\code{"WLE"} (weighted likelihood estimates) and
%\code{"Pop"} (population trait distribution) can be specified.
%}

%\details{
%A Wright map is only created for models with an assumed normal distibution.
%Hence, not for all models of the \code{\link{tamaan}} functions
%Wright maps are created.
%}


\value{
Function \code{IRT.threshold}:\cr
Matrix with Thurstonian thresholds

Function \code{IRT.WrightMap}: \cr	
A Wright map generated by the \pkg{WrightMap} package.
}



%\references{
%% ~put references to the literature/web site here ~
%}

\author{
The \code{IRT.WrightMap} function is based on the 
\code{\link[WrightMap:wrightMap]{wrightMap}} function
in the \pkg{\link[WrightMap:WrightMap]{WrightMap}} package, see
\url{http://cran.r-project.org/web/packages/WrightMap/index.html}.
}

\note{		
See \url{http://wrightmap.org/post/107431190622/wrightmap-multifaceted-models}
for creating Wright maps for multi-faceted models.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
See the \code{\link[WrightMap:wrightMap]{wrightMap}} function in
the \pkg{WrightMap} package.

See \url{http://wrightmap.org/WrightMap} fur tutorials
of the \pkg{WrightMap} package.
}

\examples{
\dontrun{
#############################################################################
# EXAMPLE 1: Fitted unidimensional model with gdm
#############################################################################

data(data.Students)
dat <- data.Students

# select part of thze dataset
resp <- dat[ , paste0("sc",1:4) ]
resp[ paste(resp[,1]) == 3 ,1] <-  2
psych::describe(resp)

# Model 1: Partial credit model in gdm
theta.k <- seq( -5 , 5 , len=21 )   # discretized ability
mod1 <- gdm( dat = resp , irtmodel="1PL" , theta.k=theta.k , skillspace="normal" ,
           centered.latent=TRUE)

# compute thresholds
thresh1 <- IRT.threshold(mod1)
print(thresh1)
IRT.WrightMap(thresh1)

#############################################################################
# EXAMPLE 2: Fitted mutidimensional model with gdm
#############################################################################

data( data.fraction2 )
dat <- data.fraction2$data
Qmatrix <- data.fraction2$q.matrix3

# Model 1: 3-dimensional Rasch Model (normal distribution)
theta.k <- seq( -4 , 4 , len=11 )   # discretized ability
mod1 <- gdm( dat , irtmodel="1PL" , theta.k=theta.k , Qmatrix=Qmatrix , 
              centered.latent=TRUE , maxiter=10 )
summary(mod1)            

# thresholds
thresh1 <- IRT.threshold(mod1)
print(thresh1)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
% \keyword{Wright map}
\keyword{Thurstonian thresholds}
% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
