% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{generate_claim_dataset}
\alias{generate_claim_dataset}
\title{Generate a Claims Dataset}
\usage{
generate_claim_dataset(
  frequency_vector,
  occurrence_list,
  claim_size_list,
  notification_list,
  settlement_list,
  no_payments_list
)
}
\arguments{
\item{frequency_vector}{a vector of claim frequencies for all the periods.}

\item{occurrence_list}{list of claim occurrence times.}

\item{claim_size_list}{list of claim sizes.}

\item{notification_list}{list of notification delays.}

\item{settlement_list}{list of settlement delays.}

\item{no_payments_list}{list of number of partial payments.}
}
\value{
A dataframe that takes the same structure as
\code{\link{test_claim_dataset}}.
}
\description{
Generates a dataset of claims records that takes the same structure as
\code{test_claim_dataset} included in this package, with each row
representing a unique claim.
}
\examples{
# demo only, in practice might generate claim dataset before simulating
# the partial payments
# this code generates the built-in test_claim_dataset
attach(test_claims_object)
claim_dataset <- generate_claim_dataset(
  frequency_vector, occurrence_list, claim_size_list, notification_list,
  settlement_list, no_payments_list
)
detach(test_claims_object)
}
\seealso{
\code{\link{test_claim_dataset}}
}
