% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survMCmulti.R
\name{survMCmulti}
\alias{survMCmulti}
\title{Survival analysis on multiple variables with MCMC}
\usage{
survMCmulti(
  var1 = NULL,
  var2 = NULL,
  var3 = NULL,
  var4 = NULL,
  var5 = NULL,
  Time,
  Event,
  chains,
  adapt,
  iter,
  data
)
}
\arguments{
\item{var1}{Variable name (first one)}

\item{var2}{Variable name (second one)}

\item{var3}{Variable name (third one)}

\item{var4}{Variable name (fourth one)}

\item{var5}{Variable name (fifth one)}

\item{Time}{Variable/Column name containing the information on duration of survival}

\item{Event}{Variable/Column name containing the information of survival event}

\item{chains}{Number of chains to perform}

\item{adapt}{Number of chains to perform}

\item{iter}{Number of iterations to perform}

\item{data}{High dimensional data having survival duration and event.}
}
\value{
Data set containing Posterior HR estimates, SD, quantiles and meandeviance.
}
\description{
Performs survival analysis using Cox Proportional Hazards with MCMC with an option to input select multiple variables.
}
\details{
The survival columns of the data should be arranged as follows -
Death Death status=1 if died otherwise 0.
OS Survival duration measured as 'OS'
}
\examples{
\dontrun{
##
data(mcsurv)
survMCmulti(var1="x1",var2=NULL,var3="x3",var4="x2",
   var5="x4",Time="OS",Event="Death",chains=2,adapt=100,iter=1000,data=mcsurv)
##
}
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R
and OpenBUGS. CRC Press.
}
\seealso{
survintMC
}
\author{
Atanu Bhattacharjee and Akash Pawar
}
