% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brier.R
\name{Brier}
\alias{Brier}
\title{Brier}
\usage{
Brier(object, pre_sp, t_star)
}
\arguments{
\item{object}{object of class \code{Surv} in the testing set created by Surv function.}

\item{pre_sp}{a vector of predicted values of survival probabilities of each observation in testing set at time t_star.}

\item{t_star}{the timepoint at which the Brier score you want to calculate.}
}
\value{
the Brier Score at time t_star
}
\description{
The Brier Score was proposed by Glenn W. Brier in 1950 which is a proper score function that measures the accuracy of probabilistic predictions, usually used to measure the accuracy of a model fit for survival data.
Brier can calculate the value of Brier Score at any timepoint,
regardless of whether it is the event time.
}
\details{
The Brier Score is the mean square difference between the true classes and the predicted probabilities. So the Brier Score can be thought of as a cost function.
Therefore, the lower the Brier Score is for a set of predictions, the better the predictions are calibrated.
The Brier Score takes on a value between zero and one, since this is the square of the largest possible difference between a predicted probability and the actual outcome.
As we all know, for the cencoring samples, we do not know the real time of death, so the residual cannot be directly calculated when making the prediction.
So the Brier Score is widely used in survival analysis.

The Brier Score is a strictly proper score (Gneiting and Raftery, 2007), which means that it takes its minimal value only when the predicted probabilities match the empirical probabilities.

Judging from the sparse empirical evidence, predictions of duration of survival tend to be rather inaccurate. More precision is achieved by using patient-specific survival probabilities and the Brier score as predictions to discriminate future survivors from failures.
}
\examples{
library(survival)
time = rexp(50)
status = sample(c(0,1),50,replace = TRUE)
pre_sp = runif(50)
t_star = runif(1)
Brier(Surv(time,status),pre_sp,t_star)

}
\references{
Graf, Erika, Schmoor, Claudia, Sauerbrei, & Willi, et al. (1999). Assessment and comparison of prognostic classification schemes for survival data. Statist. Med., 18(1718), 2529-2545.

Brier, G. W. (1950). Verification of forecasts expressed in terms of probability. Monthly Weather Review, 78.

Gneiting, T. , &  Raftery, A. E. . (2007). Strictly Proper Scoring Rules, Prediction, and Estimation.
}
\author{
Hanpu Zhou \email{zhouhanpu@csu.edu.cn}
}
