% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surr_rsq_ci.R
\name{surr_rsq_ci}
\alias{surr_rsq_ci}
\title{A function to calculate the interval estimate of the surrogate R-squared measure}
\usage{
surr_rsq_ci(surr_rsq, alpha = 0.05, B = 1000, ...)
}
\arguments{
\item{surr_rsq}{A object of class \code{"surr_rsq"} that is generated by the function \code{"surr_rsq"}.
It contains the following components: \code{surr_rsq}, \code{reduced_model}, \code{full_model}, and \code{data}.}

\item{alpha}{The significance level alpha. The confidence level is 1-alpha.}

\item{B}{The number of bootstrap replications.}

\item{...}{Additional optional arguments.}
}
\value{
An list that contains the CI_lower, CI_upper.
}
\description{
This function generates the interval measure of surrogate R-squared by bootstrap.
}
\examples{
data("RedWine")

full_formula <- as.formula(quality ~ fixed.acidity + volatile.acidity + citric.acid
+ residual.sugar + chlorides + free.sulfur.dioxide +
total.sulfur.dioxide + density + pH + sulphates + alcohol)

fullmodel <- polr(formula = full_formula,data=RedWine, method  = "probit")

select_model <- update(fullmodel, formula. = ". ~ . - fixed.acidity -
citric.acid - residual.sugar - density")

surr_rsq_select <- surr_rsq(select_model, fullmodel, data = RedWine, avg.num = 30)

# surr_rsq_ci(surr_rsq_select, alpha = 0.05, B = 1000) # Not run, it takes time.

}
