% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_SurvSurv.R
\name{fit_model_SurvSurv}
\alias{fit_model_SurvSurv}
\title{Fit Survival-Survival model}
\usage{
fit_model_SurvSurv(
  data,
  copula_family,
  n_knots = 2,
  fitted_model = NULL,
  method = "BFGS",
  maxit = 500
)
}
\arguments{
\item{data}{A data frame in the correct format (See details).}

\item{copula_family}{One of the following parametric copula families:
\code{"clayton"}, \code{"frank"}, \code{"gaussian"}, or \code{"gumbel"}.}

\item{n_knots}{Number of internal knots for the Royston-Parmar survival model.}

\item{fitted_model}{Fitted model from which initial values are extracted. If
\code{NULL} (default), standard initial values are used. This option intended
for when a model is repeatedly fitted, e.g., in a bootstrap.}

\item{method}{Optimization algorithm for maximizing the objective function.
For all options, see \code{?maxLik::maxLik}. Defaults to \code{"BFGRS"}.}

\item{maxit}{Maximum number of iterations for the numeric optimization,
defaults to 500.}
}
\value{
Returns an S3 object that can be used to perform the sensitivity
analysis with \code{\link[=sensitivity_analysis_SurvSurv_copula]{sensitivity_analysis_SurvSurv_copula()}}.
}
\description{
The function \code{fit_model_SurvSurv()} fits the copula model for time-to-event
surrogate and true endpoints (Stijven et al., 2022). Because the bivariate
distributions of the surrogate-true endpoint pairs are functionally
independent across treatment groups, a bivariate distribution is fitted in
each treatment group separately. The marginal distributions are based on the Royston-Parmar
survival model (Royston and Parmar, 2002).
}
\section{Model}{
In the causal-inference approach to evaluating surrogate endpoints, the first
step is to estimate the joint distribution of the relevant potential
outcomes. Let \eqn{(T_0, S_0, S_1, T_1)'} denote the vector of potential
outcomes where \eqn{(S_k, T_k)'} is the pair of potential outcomes under
treatment \eqn{Z = k}. \eqn{T} refers to the true endpoint, e.g., overall
survival. \eqn{S} refers to the composite surrogate endpoint, e.g.,
progression-free-survival. Because \eqn{S} is
usually a composite endpoint with death as possible event, modeling
difficulties arise because \eqn{Pr(S_k = T_k) > 0}.

Due to difficulties in modeling the composite surrogate and the true endpoint
jointly, the time-to-surrogate event (\eqn{\tilde{S}}) is modeled instead of
the time-to-composite surrogate event (\eqn{S}). Using this new variable,
\eqn{\tilde{S}}, a D-vine copula model is proposed for \eqn{(T_0,
\tilde{S}_0, \tilde{S}_1, T_1)'} in Stijven et al. (2022). However, only the
following bivariate distributions are identifiable \eqn{(T_k, \tilde{S}_k)'}
for \eqn{k=0,1}. The margins in these bivariate distributions are based on
the Royston-Parmar survival model (Roystona and Parmar, 2002). The
association is modeled through two copulas of the same parametric form, but
with unique copula parameters.

Two modelling choices are made before estimating the two bivariate
distributions described in the previous paragraph:
\itemize{
\item The number of internal knots for the Royston-Parmar survival models. This
is specified through the \code{n_knots} argument. The number of knots is assumed to
be equal across the four margins.
\item The parametric family of the bivariate copulas. The parametric family is
assumed to be equal across treatment groups. This choice is specified through
the \code{copula_family} argument.
}
}

\section{Data Format}{
The data frame should have the semi-competing risks format. The columns must
be ordered as follows:
\itemize{
\item time to surrogate event, true event, or independent censoring; whichever
comes first
\item time to true event, or independent censoring; whichever comes first
\item treatment indicator: 0 or 1
\item surrogate event indicator: 1 if surrogate event is observed, 0 otherwise
\item true event indicator: 1 if true event is observed, 0 otherwise
}

Note that according to the methodology in Stijven et al. (2022), the
surrogate event must not be the composite event. For example, when the
surrogacy of progression-free survival for overall survival is evaluated. The
surrogate event is progression, but not the composite event of progression or
death.
}

\examples{
if(require(Surrogate)) {
  data("Ovarian")
  #For simplicity, data is not recoded to semi-competing risks format, but is
  #left in the composite event format.
  data = data.frame(Ovarian$Pfs,
                    Ovarian$Surv,
                    Ovarian$Treat,
                    Ovarian$PfsInd,
                    Ovarian$SurvInd)
  Surrogate::fit_model_SurvSurv(data = data,
                                copula_family = "clayton",
                                n_knots = 1)
}

}
\references{
Stijven, F., Alonso, a., Molenberghs, G., Van Der Elst, W., Van
Keilegom, I. (2022). An information-theoretic approach to the evaluation of
time-to-event surrogates for time-to-event true endpoints based on causal
inference.

Royston, P., & Parmar, M. K. (2002). Flexible parametric proportional-hazards
and proportional-odds models for censored survival data, with application to
prognostic modelling and estimation of treatment effects. Statistics in
medicine, 21(15), 2175-2197.
}
\seealso{
\code{\link[=marginal_gof_scr]{marginal_gof_scr()}}, \code{\link[=sensitivity_analysis_SurvSurv_copula]{sensitivity_analysis_SurvSurv_copula()}}
}
\author{
Florian Stijven
}
