% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimTrial1}
\alias{SimTrial1}
\title{Simulates a Sub-TITE trial design}
\usage{
SimTrial1(
  nSims,
  Nmax,
  T1,
  Target,
  Dose,
  DoseStart,
  Upper,
  Accrue,
  groupprob,
  Family,
  Param1,
  Param2,
  meanmu,
  meanslope,
  MeanInts,
  MeanSlopes,
  varint,
  varbeta,
  phetero,
  NSep,
  NBorrow,
  cohort,
  FULLY
)
}
\arguments{
\item{nSims}{Number of Trials to Simulate.}

\item{Nmax}{Maximum Number of Patients to enroll in the trial.}

\item{T1}{Reference time for toxicity.}

\item{Target}{Target cumulative toxicity probability (or subgroup specific vector) at time T1.}

\item{Dose}{Standardized vector of doses to try.}

\item{DoseStart}{Dose (or vector of Doses) to enroll the first patient in each subgroup at.}

\item{Upper}{Cutoff values used to determine if accrual in a subgroup should be suspended.}

\item{Accrue}{Expected montly patient accrual rate.}

\item{groupprob}{Probability vector of subgroup assignment.}

\item{Family}{What distribution Family to simulate from. Options include: Exponential,Gamma, Lognormal, Uniform, Weibull.}

\item{Param1}{nGroups X nDose matrix of first parameter values.}

\item{Param2}{NGroups X nDose matrix of second parameter values.}

\item{meanmu}{Prior mean of the baseline intercept parameter.}

\item{meanslope}{Prior mean of the baseline slope parameter.}

\item{MeanInts}{G-1 length vector of subgroup specific prior intercept means.}

\item{MeanSlopes}{G-1 length vector of subgroup specific prior slope means.}

\item{varint}{Prior Variance of Intercept Parameters.}

\item{varbeta}{Prior Variance of Slope Parameters.}

\item{phetero}{Prior prob of heterogeneity.}

\item{NSep}{Number of patients to assign based on no borrowing.}

\item{NBorrow}{Number of patients to assign based on no clustering}

\item{cohort}{Number of patients to enroll before escalating.}

\item{FULLY}{Do we have to fully evaluate a cohort before escalating?}
}
\value{
A list of simulation outputs to be processed in R.
}
\description{
Simulates replicates from a Sub-TITE trial with user specified true toxicity time distributions for different doses and subgroups and returns average summary statistics of the trial.
}
