% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_ref_switch_function.R
\name{DiversityDom}
\alias{DiversityDom}
\alias{homogeneityDom}
\alias{dissimilarityDom}
\alias{contrastDom}
\alias{entropyDom}
\alias{entropyNormDom}
\title{Spatial Structural Diversity Metrics}
\usage{
homogeneityDom(rank, delta, PMat, xVal, nrp)

dissimilarityDom(rank, delta, PMat, xVal, nrp)

contrastDom(rank, delta, PMat, xVal, nrp)

entropyDom(rank, delta, PMat, xVal, nrp)

entropyNormDom(rank, delta, PMat, xVal, nrp)
}
\arguments{
\item{rank}{logical. Should values be replaced with ranks in the co-occurrence 
matrix (GLCM)? Defaults to \code{FALSE}.}

\item{delta}{numeric, takes 3 options: \code{0}, \code{1}, or \code{2}. 
The parameter \code{delta} is the difference weight parameter, 
it defines how the differences between pixel values within a pixel pair should be weighted.  
If \code{rank = TRUE}, delta defines how the differences between ranks should be weighted.  
The default value is \code{0} (no weight). Set \code{delta = 1} for absolute weights, 
or \code{delta = 2} for square weights. 
The \code{delta} parameter can only be set when the metric \code{entropyDom} is used. 
The metric \code{dissimilarityDom} automatically employs \code{delta = 1}, and \code{contrastDom} employs \code{delta = 2}.}

\item{PMat}{the GLCM that is returned by an internal function
to the \code{\link{strucDivDom}} function.}

\item{xVal}{the unique values in the raster layer. calculated internally.}

\item{nrp}{the normalizing constant calculated internally based on the raster dimensions.}
}
\description{
The functions \code{entropyDom} , \code{entropyNormDom}, \code{contrastDom}, \code{dissimilarityDom} 
and \code{homogeneityDom} are the spatial structural diversity metrics used in the default 
configurations of \code{\link{strucDivDom}}. 
For programming reasons, these metrics have different name endings than the metrics used in the functions
\code{\link{strucDiv}} and \code{\link{strucDivNest}}, but they have the same mathematical formulation. 
Hence, \code{entropyDom} is specified by the same equation as \code{entropy}, and so forth.
Structural diversity entropy is \code{entropyDom} with different \code{delta} parameters. 
Shannon entropy is employed, when \code{delta = 0}. 
The metric \code{entropyDom} has a scale-dependent maximum. Scale, here, refers to the extent of the domain.
The metric \code{entropyNormDom} is Shannon entropy normalized over maximum entropy. 
The metric \code{entropyNormDom} ranges between 0 and 1.
Additionally, the value gradient is considered with \code{delta = 1} and \code{delta = 2}. 
The values of structural diversity entropy with \code{delta = 1} or \code{delta = 2} are not restricted and depend on the values of the input raster.
The metric \code{dissimilarityDom} employs \code{delta = 1}, \code{contrastDom} employs \code{delta = 2}. 
The values of \code{dissimilarityDom} and \code{contrastDom} are not restricted and depend on the values of the input raster. 
The metric \code{homogeneityDom} quantifies the closeness of empirical probabilities to the diagonal and ranges between 0 and 1.
}
\details{
These functions are used internally and are called 
as an argument to the \code{\link{strucDivDom}}.
}
