% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{rotate}
\alias{rotate}
\title{Spherical rotation around fixed axes}
\usage{
rotate(dec, inc, rdec, rinc, rmag)
}
\arguments{
\item{dec}{declination of the data; it is the angle from the north
taken on an horizontal plane. It is measured clockwise from North and ranges
from 0 to 360° (Tauxe 2010).}

\item{inc}{inclination of the data; it is the angle from the
horizontal, is positive downward, and ranges from +90° for straight down to
-90° for straight up (Tauxe, 2010).}

\item{rdec}{declination of the rotation axes (of length 1 or n).}

\item{rinc}{inclination of the rotation axes (of length 1 or n).}

\item{rmag}{magnitude of rotation (following the notation of the
Stereonet software): a positive rotation is clockwise looking in the
direction of the given declination and inclination; of length 1 or n).}
}
\description{
Spherical rotation around given rotation axes
}
\examples{
earnet()

inc <- seq(0,85,5)
dec <- rep(0,length(inc))

earpoints(dec,inc)

rdec <- rep(0, length(inc))
rinc <- rep(90, length(inc))

mag <- 90
rmag  <- seq(mag, 0, by = -mag/(length(inc)-1))

rot <- rotate(dec,inc,rdec,rinc,rmag)

earpoints(dec = round(rot$dec,digits = 2), inc = round(rot$inc,digits = 2),
          l = list(bg = "green"),
          u = list(bg = "blue"),
          h = list(bg = "yellow"))

earpoints(dec = 0, inc = 90, l = list(bg = "red"))

}
\references{
\itemize{
  \item Tauxe, L., 2010. Essentials of Paleomagnetism. University of
  California Press.
  \item Allmendinger, R. W., Cardozo, N. C., and Fisher, D., 2013, Structural
  Geology Algorithms: Vectors & Tensors: Cambridge, England, Cambridge
  University Press, 289 pp.
  \item Cardozo, N., and Allmendinger, R. W., 2013, Spherical projections
  with OSXStereonet: Computers & Geosciences, v. 51, no. 0, p. 193 - 205,
  doi: 10.1016/j.cageo.2012.07.021
}
}
\seealso{
\code{\link{rmatrix}}, \code{\link{restore}} and
\code{\link{reposition}}
}
