% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_weibull.R
\name{submod_weibull}
\alias{submod_weibull}
\title{Subgroup Identification: Model-based partitioning (Weibull)}
\usage{
submod_weibull(Y, A, X, Xtest, mu_train, alpha = 0.05,
  minsize = floor(dim(X)[1] * 0.1), maxdepth = 4, parm = NULL, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{mu_train}{Patient-level estimates (See PLE_models)}

\item{alpha}{Significance level for variable selection (default=0.05)}

\item{minsize}{Minimum number of observations in a tree node.
Default = floor( dim(train)[1]*0.05  )}

\item{maxdepth}{Maximum depth of any node in the tree (default=4)}

\item{parm}{Model parameters included in parameter instability tests 
(default=NULL, all parameters)}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained MOB (Weibull) model.
 \itemize{
  \item mod - MOB (Weibull) model object
}
}
\description{
Uses the MOB (with weibull loss function) algorithm to identify subgroups
(Zeileis, Hothorn, Hornik 2008; Seibold, Zeileis, Hothorn 2016). Usable for
survival outcomes.
}
\examples{


\donttest{
library(StratifiedMedicine)

## Load TH.data (no treatment; generate treatment randomly to simulate null effect) ##
data("GBSG2", package = "TH.data", envir = e <- new.env() )
surv.dat = e$GBSG2
## Design Matrices ###
Y = with(surv.dat, Surv(time, cens))
X = surv.dat[,!(colnames(surv.dat) \%in\% c("time", "cens")) ]
A = rbinom( n = dim(X)[1], size=1, prob=0.5  )
res_weibull = submod_weibull(Y, A, X, Xtest=X, family="survival")
plot(res_weibull$mod)
}


}
\references{
\itemize{
\item Zeileis A, Hothorn T, Hornik K (2008). Model-Based Recursive Partitioning. 
Journal of Computational and Graphical Statistics, 17(2), 492–514.
\item Seibold H, Zeileis A, Hothorn T. Model-based recursive partitioning for 
subgroup analyses. Int J Biostat, 12 (2016), pp. 45-63
}
}
