% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_lm.R
\name{param_lm}
\alias{param_lm}
\title{Parameter Estimation: Linear Regression}
\usage{
param_lm(Y, A, X, mu_hat, Subgrps, alpha_ovrl, alpha_s, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate matrix. Must be numeric.}

\item{mu_hat}{Patient-level estimates (See PLE_models)}

\item{Subgrps}{Identified subgroups (can be the overall population)}

\item{alpha_ovrl}{Two-sided alpha level for overall population}

\item{alpha_s}{Two-sided alpha level at subgroup}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Data-set with parameter estimates (average treatment effect) and corresponding
variability metrics, for overall and subgroups.
 \itemize{
  \item param.dat - Parameter estimates and variability metrics.
  By convention, Subgrps=0 corresponds to overall population.
  }
}
\description{
For each identified subgroups and in the overall population, fit separate linear regressions.
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

## Identify Subgroups: MOB (lmtree) ##
res_lmtree = submod_lmtree(Y, A, X,  Xtest=X)

## Parameter-estimation ##
params = param_lm(Y, A, X, Subgrps = res_lmtree$Subgrps.train, alpha_ovrl=0.05,
                  alpha_s=0.05)
params


}
