% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getObs}
\alias{getObs}
\alias{getObs,stormsList-method}
\alias{getObs,storm-method}
\title{Getting observations}
\usage{
getObs(s, ...)

\S4method{getObs}{stormsList}(s, name, season = NULL)

\S4method{getObs}{storm}(s)
}
\arguments{
\item{s}{\code{storm} or \code{stormsList} object}

\item{...}{extra argument for \code{stormsList}}

\item{name}{character. Name of the storm in capital letters.}

\item{season}{numeric. Cyclonic season of the \code{storm}. Required only
if several \code{storm} in the \code{s} object have the same name.
Default value is set to \code{NULL}.}
}
\value{
A data.frame.
}
\description{
The \code{getObs()} function returns observed track data for a storm
in a \code{storm} or \code{stormsList} object.
}
\examples{
\donttest{
#Creating a stormsDataset
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting the observed track data for the tropical
#cyclone Niran in the sts object
getObs(getStorm(sts, name = "NIRAN"))
getObs(sts, name = "NIRAN")
}
}
