% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_regressor.R
\name{linear_regressor}
\alias{linear_regressor}
\title{R6 Class Representing a Linear Regression}
\description{
An R6-class for linear regression that is used
  within the StabilizedRegression framework.

  Currently this is the only regression procedure that has been
  implemented. In order to extend the StabilizedRegression
  framework to a different regression procedure a custom R6-class
  with the same structure as this function can be written and used
  within StabilizedRegression.
}
\details{
Constructer method initializes a linear regression object
  specifying on which subset of variables \code{S} to fit the
  regression and which type of stability test and prediction score
  to compute. The methods \code{fit()} and \code{predict()} can be
  applied to the object to fit and predict, respectively.
}
\author{
Niklas Pfister
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{estimator}}{Numeric vector of
regression coefficients.}

\item{\code{S}}{Numeric vector specifying
the subset of variables to perform
regression on.}

\item{\code{scores}}{Numeric vector of
fitted stability and prediction scores.}

\item{\code{pars}}{List specifying the
stability test via \code{test} and
prediction score via \code{pred_score}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{linear_regressor$new()}}
\item \href{#method-fit}{\code{linear_regressor$fit()}}
\item \href{#method-predict}{\code{linear_regressor$predict()}}
\item \href{#method-clone}{\code{linear_regressor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new linear_regression object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{linear_regressor$new(
  S = numeric(),
  pars = list(test = "mean", pred_score = c("mse", "mse"))
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{Subset of variables.}

\item{\code{pars}}{Parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `linear_regression` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\subsection{Method \code{fit()}}{
Fit a 'linear_regression' object on data
and computes the stability and prediction scores.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{linear_regressor$fit(X, Y, A, extra = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Predictor matrix.}

\item{\code{Y}}{response vector.}

\item{\code{A}}{environemnt indicator.}

\item{\code{extra}}{not required (placeholder)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A fitted `linear_regression` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\subsection{Method \code{predict()}}{
Predict using a fitted 'linear_regression' object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{linear_regressor$predict(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Predictor matrix on which to predict response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Numeric vector of predicted response.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{linear_regressor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
