% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_functions.R
\name{update.Spower}
\alias{update.Spower}
\title{Update compromise or prospective/post-hoc power analysis without re-simulating}
\usage{
\method{update}{Spower}(object, sig.level = 0.05, beta_alpha = NULL, predCI = 0.95, ...)
}
\arguments{
\item{object}{object returned from \code{\link{Spower}} where \code{power}
was estimated or the \code{bete_alpha} criteria were supplied}

\item{sig.level}{Type I error rate (alpha)}

\item{beta_alpha}{Type II/Type I error ratio}

\item{predCI}{confidence interval precision (see \code{\link{Spower}} for
similar input)}

\item{...}{arguments to be passed}
}
\value{
object of class \code{Spower} with updated information
}
\description{
When a power or compromise analysis was performed in
\code{\link{Spower}} this function can be used to
update the compromise or power criteria without the need for re-simulating
the experiment. For compromise analyses a \code{beta_alpha} criteria
must be supplied, while for prospective/post-hoc power analyses the \code{sig.level}
must be supplied.
}
\examples{
\donttest{

########
## Prospective power analysis update

# Estimate power using sig.level = .05 (default)
out <- p_t.test(n = 50, d = .5) |> Spower()

# update power estimate given sig.level=.01 and .20
update(out, sig.level=.01)
update(out, sig.level=.20)


########
## Compromise analysis update

# Solve beta/alpha ratio to specific error trade-off constant
out <- p_t.test(n = 50, d = .5) |> Spower(beta_alpha = 2)

# update beta_alpha criteria without re-simulating
update(out, beta_alpha=4)

# also works if compromise not initially run but prospective/post-hoc power was
out <- p_t.test(n = 50, d = .5) |> Spower()
update(out, beta_alpha=4)

}

}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
