% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prediction_Functions.R
\name{predict.cv.SplitGLM}
\alias{predict.cv.SplitGLM}
\title{Predictions for cv.SplitGLM Object}
\usage{
\method{predict}{cv.SplitGLM}(object, newx, group_index = NULL, type = c("prob", "class")[1], ...)
}
\arguments{
\item{object}{An object of class cv.SplitGLM.}

\item{newx}{New data for predictions.}

\item{group_index}{The group for which to return the coefficients. Default is the ensemble.}

\item{type}{The type of predictions for binary response. Options are "prob" (default) and "class".}

\item{...}{Additional arguments for compatibility.}
}
\value{
The predictions for the cv.SplitGLM object.
}
\description{
\code{predict.cv.SplitGLM} returns the predictions for a SplitGLM object.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
n <- 50
N <- 2000
p <- 1000
beta.active <- c(abs(runif(p, 0, 1/2))*(-1)^rbinom(p, 1, 0.3))
# Parameters
p.active <- 100
beta <- c(beta.active[1:p.active], rep(0, p-p.active))
Sigma <- matrix(0, p, p)
Sigma[1:p.active, 1:p.active] <- 0.5
diag(Sigma) <- 1

# Train data
x.train <- mvnfast::rmvn(n, mu = rep(0, p), sigma = Sigma) 
prob.train <- exp(x.train \%*\% beta)/
              (1+exp(x.train \%*\% beta))
y.train <- rbinom(n, 1, prob.train)
mean(y.train)
# Test data
x.test <- mvnfast::rmvn(N, mu = rep(0, p), sigma = Sigma)
prob.test <- exp(x.test \%*\% beta)/
             (1+exp(x.test \%*\% beta))
y.test <- rbinom(N, 1, prob.test)
mean(y.test)

# SplitGLM - CV (Multiple Groups)
split.out <- cv.SplitGLM(x.train, y.train,
                         glm_type="Logistic",
                         G=10, include_intercept=TRUE,
                         alpha_s=3/4, alpha_d=1,
                         n_lambda_sparsity=50, n_lambda_diversity=50,
                         tolerance=1e-3, max_iter=1e3,
                         n_folds=5,
                         active_set=FALSE,
                         n_threads=1)
split.coef <- coef(split.out)
# Predictions
split.prob <- predict(split.out, newx=x.test, type="prob", group_index=NULL)
split.class <- predict(split.out, newx=x.test, type="class", group_index=NULL)
plot(prob.test, split.prob, pch=20)
abline(h=0.5,v=0.5)
mean((prob.test-split.prob)^2)
mean(abs(y.test-split.class))

}

}
\seealso{
\code{\link{cv.SplitGLM}}
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
