% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txt2csv.R
\name{txt2csv}
\alias{cmbl2csv}
\alias{sstab2csv}
\alias{txt2csv}
\title{Utility Functions to Clean and Convert Spectral Files to csv}
\usage{
txt2csv(in.file = "", out.file = "")
}
\arguments{
\item{in.file}{The name of the input file.}

\item{out.file}{The name of the output file.}
}
\value{
A modifed file in csv format.
}
\description{
These functions clean out extraneous information from exported spectral data
files and then write them out in csv format.  \code{txt2csv} and \code{cmbl2csv} handle
files exported by LoggerPro software.  \code{sstab2csv} handles files exported by
Spectra Suite software.  Not directly called by the user.
}
\details{
Extraneous text at the beginning of the file is removed.  In the case of
cmbl files, lines containing "Z2" or ">" are removed.  Absorbances marked as
"Z1" are replaced with zero.  The data are initially in one long column; the
wavelength and absorbances are reunited into two columns.
}
\author{
Bryan A. Hanson, DePauw University.
}
\seealso{
\code{\link{gatherSpecFiles}} which is the function the user should
call.
}
\keyword{utilities}

