% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STmodel.R
\name{summary.STmodel}
\alias{summary.STmodel}
\title{Computes summary details for \code{STmodel} object}
\usage{
\method{summary}{STmodel}(object, type = object$covars$type, ...)
}
\arguments{
\item{object}{\code{STmodel} object to compute summary information for.}

\item{type}{Factorial of \code{length(x$locations$ID)}, if not \code{NULL}
the output also presents summaries of number of sites and observations
as well as time periods per type of site.}

\item{...}{Ignored additional arguments.}
}
\value{
A \code{summary.STmodel} object.
}
\description{
\code{\link[base:summary]{summary}} method for class \code{STmodel}.
}
\examples{
##load some data
data(mesa.model)
##Summary of data fields.
summary(mesa.model)

}
\seealso{
Other STmodel methods: \code{\link{MCMC.STmodel}},
  \code{\link{c.STmodel}}, \code{\link{createSTmodel}},
  \code{\link{estimate.STmodel}},
  \code{\link{estimateCV.STmodel}},
  \code{\link{plot.STdata}}, \code{\link{predict.STmodel}},
  \code{\link{print.STmodel}},
  \code{\link{print.summary.STmodel}},
  \code{\link{qqnorm.predCVSTmodel}},
  \code{\link{scatterPlot.predCVSTmodel}},
  \code{\link{simulate.STmodel}}
}
\author{
Johan Lindstrom
}
