% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EBpostdens.R
\name{EBpostdens}
\alias{EBpostdens}
\title{Produce plots of empirical Bayes posterior densities when the data Y are Poisson with expected number E and relative risk theta, with the latter having a gamma distribution with known values alpha and beta, which are estimated using empirical Bayes.}
\usage{
EBpostdens(
  Y,
  E,
  alpha,
  beta,
  Xrow = NULL,
  lower = NULL,
  upper = NULL,
  main = ""
)
}
\arguments{
\item{Y}{observed disease counts}

\item{E}{expected disease counts}

\item{alpha}{x}

\item{beta}{x}

\item{Xrow}{x}

\item{lower}{x}

\item{upper}{x}

\item{main}{x}
}
\value{
A plot containing the gamma posterior distribution
}
\description{
This function produces plots of empirical Bayes posterior densities which are gamma distributions with parameters (alpha+Y, (alpha+E*mu)/mu) where mu = exp(x beta). The SMRs are drawn on for comparison.
}
\examples{
data(scotland)
Y <- scotland$data$cases
E <- scotland$data$expected
ebresults <- eBayes(Y,E)
EBpostdens(Y[1], E[1], ebresults$alpha, ebresults$beta, lower=0, upper=15,
          main="Area 1")
}
\author{
Jon Wakefield
}
