% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{PropCellTypes-class}
\alias{PropCellTypes-class}
\alias{PropCellTypes}
\title{The PropCellTypes Class}
\description{
The \code{\linkS4class{PropCellTypes}} class is a data storage class which
contains information related to the cell type composition matrices used to
simulate mixed transcriptional profiles. This matrix is stored in the
\code{prob.matrix} slot while the rest contains additional information
generated during the process and required in subsequent steps.
}
\details{
See \code{?\link{genMixedCellProp}} function for information about how cell
type composition matrices are generated. Plots about the cell type proportion
distributions can be accessed using the \code{\link{showProbPlot}} function
(see \code{?\link{showProbPlot}} for more details).
}
\section{Slots}{

\describe{
\item{\code{prob.matrix}}{Matrix of cell type proportions to simulate mixed
transcriptional profiles.}

\item{\code{cell.names}}{Matrix containing the name of cells to be used to generate
the simulated mixed transcriptional profiles.}

\item{\code{set.list}}{List of cells ordered according to the cell type they belong
to.}

\item{\code{set}}{Vector containing cell names present in the object.}

\item{\code{method}}{Vector containing the method by which cell type proportions were
generated.}

\item{\code{plots}}{Plots showing the distribution of the cell type proportions. See
\code{?\link{showProbPlot}} for more details.}

\item{\code{type.data}}{Character indicating the type of data contained: train or
test.}
}}

