% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/altieri_entropy.R
\name{spat_entropy}
\alias{spat_entropy}
\title{Altieri's spatial entropy.}
\usage{
spat_entropy(data, adj.list, shannZ, missing.cat = NULL)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...
If the dataset is a point pattern, \code{data} is the mark vector.}

\item{adj.list}{A list of adjacency matrices, provided by user or returned by \code{\link[=adj_list]{adj_list()}}.
Each element of the list contains a binary adjacency matrix for building pairs at a specific distance,
provided by user or returned by \code{\link[=adj_mat]{adj_mat()}}.}

\item{shannZ}{The output of \code{\link[=shannonZ]{shannonZ()}}: Shannon's entropy of \eqn{Z}
as well as the pairs frequency table.}

\item{missing.cat}{Optional, a vector with the names of all categories that are absent in \code{data}.}
}
\value{
A list with elements:
\itemize{
\item \code{mut.global} the spatial mutual information
\item \code{res.global} the global residual entropy
\item \code{shannZ} Shannon's entropy of \eqn{Z}
\item \code{mut.local} the partial information terms
\item \code{res.local} the partial residual entropies
\item \code{pwk} the spatial weights for each distance range
\item \code{pzr.marg} the marginal probability distribution of \eqn{Z}
\item \code{pzr.cond} a list with the conditional probability distribution of \eqn{Z} for each distance range
\item \code{Q} the number of pairs (realizations of \eqn{Z})
\item \code{Qk} the number of pairs for each distance range.
}
}
\description{
This function computes spatial mutual information and spatial residual entropy as in Altieri et al (2017).
References can be found at \code{SpatEntropy}.
}
\details{
The computation of Altieri's entropy starts from a point or areal dataset, for which
Shannon's entropy of the transformed variable \eqn{Z} (for details see \code{\link{shannonZ}})
\deqn{H(Z)=\sum p(z_r)\log(1/p(z_r))}
is computed using all
possible pairs within the observation area. Then, its two components
spatial mutual information
\deqn{MI(Z,W)=\sum p(w_k) \sum p(z_r|w_k)\log(p(z_r|w_k)/p(z_r))}
and spatial residual entropy
\deqn{H(Z)_W=\sum p(w_k) \sum p(z_r|w_k)\log(1/p(z_r|w_k))}
are calculated
in order to account for the overall role of space in determining
the data heterogeneity. Besides, starting from a partition into distance
classes, a list of adjacency matrices is
built using \code{\link[=adj_mat]{adj_mat()}}, which identifies what pairs of units
must be considered for each class. Spatial mutual information and spatial residual
entropy are split into local terms according to the chosen distance breaks, so that the role of space
can be investigated.
}
\examples{
data=matrix(sample(1:5, 25, replace=TRUE), nrow=5)
plot(as.im(data, W=square(5)))
dist.breaks=c(0,1,2,5,5*sqrt(2))
dist.mat=euclid_dist(coords_pix(square(5), nrow=5, ncol=5))
my.adj.list=adj_list(dist.mat, dist.breaks) #see adj_list
my.shZ=shannonZ(data)
spat_entropy(data=data, adj.list=my.adj.list, shannZ=my.shZ)

}
