% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseVFC.R
\name{SparseVFC}
\alias{SparseVFC}
\title{Sparse Vector Field Consensus}
\usage{
SparseVFC(
  X,
  Y,
  M = 16,
  MaxIter = 500,
  gamma = 0.9,
  beta = 0.1,
  lambda = 3,
  theta = 0.75,
  a = 10,
  ecr = 1e-05,
  minP = 1e-05,
  silent = TRUE
)
}
\arguments{
\item{X}{The position of the vectors.}

\item{Y}{The value of the vectors.}

\item{M}{The number of the basis functions used for sparse approximation. Default value is 16.}

\item{MaxIter}{Maximum iteration times. Default value is 500.}

\item{gamma}{Percentage of inliers in the samples. This is an initial value for EM iteration, and it is not important. Default value is 0.9.}

\item{beta}{Parameter of Gaussian Kernel, \eqn{k(x, y) = exp(-beta*||x-y||^2)}. Default value is 0.1.}

\item{lambda}{Represents the trade-off between the goodness of data fit and smoothness of the field. Default value is 3.}

\item{theta}{If the posterior probability of a sample being an inlier is larger than theta, then it will be regarded as an inlier. Default value is 0.75.}

\item{a}{Parameter of the uniform distribution. We assume that the outliers obey a uniform distribution \eqn{1/a}. Default Value is 10.}

\item{ecr}{The minimum limitation of the energy change rate in the iteration process. Default value is 1e-5.}

\item{minP}{The posterior probability Matrix P may be singular for matrix inversion. We set the minimum value of P as \code{minP}. Default value is 1e-5.}

\item{silent}{Should the messages be suppressed? Default value is \code{TRUE}.}
}
\value{
A \code{VFC} object, which is a list containing the following elements:
\describe{
\item{X}{A matrix of the positions of kernels.}
\item{Y}{A matrix of the input vectors.}
\item{beta}{The input value of \code{beta}.}
\item{V}{A matrix of the estimated vectors.}
\item{C}{A matrix of the coefficients of each kernel.}
\item{P}{A vector of the posterior probability of the input vectors (\code{Y}) being an inlier.}
\item{VFCIndex}{A vector of indices of the inliers.}
\item{sigma2}{The \eqn{\sigma^2} of the estimations weighted by \code{P}.}
}
}
\description{
The main function for the SparseVFC algorithm.
See \code{References} for more information.
}
\examples{
data(church)
set.seed(1614)
VecFld <- SparseVFC(norm_vecs(church$X), norm_vecs(church$Y) - norm_vecs(church$X))
predict(VecFld, c(0, 0))
}
\references{
The algorithm is described in Ma et al. (2013) \doi{10.1016/j.patcog.2013.05.017}.
This function is translated with permission from Jiayi Ma's Matlab function at \url{https://github.com/jiayi-ma/VFC}.
Also see Zhao et al. (2011) \doi{10.1109/CVPR.2011.5995336} for the earlier VFC algorithm.
}
