% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog.R
\name{createTable}
\alias{createTable}
\title{Creates a table based on the dataset in a data source}
\usage{
createTable(tableName, path = NULL, source = NULL, schema = NULL,
  ...)
}
\arguments{
\item{tableName}{the qualified or unqualified name that designates a table. If no database
identifier is provided, it refers to a table in the current database.}

\item{path}{(optional) the path of files to load.}

\item{source}{(optional) the name of the data source.}

\item{schema}{(optional) the schema of the data required for some data sources.}

\item{...}{additional named parameters as options for the data source.}
}
\value{
A SparkDataFrame.
}
\description{
Creates a table based on the dataset in a data source. Returns a SparkDataFrame associated with
the table.
}
\details{
The data source is specified by the \code{source} and a set of options(...).
If \code{source} is not specified, the default data source configured by
"spark.sql.sources.default" will be used. When a \code{path} is specified, an external table is
created from the data at the given path. Otherwise a managed table is created.
}
\note{
createTable since 2.2.0
}
\examples{
\dontrun{
sparkR.session()
df <- createTable("myjson", path="path/to/json", source="json", schema)

createTable("people", source = "json", schema = schema)
insertInto(df, "people")
}
}
