% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib.R
\docType{methods}
\name{spark.naiveBayes}
\alias{spark.naiveBayes}
\alias{predict,NaiveBayesModel-method}
\alias{summary,NaiveBayesModel-method}
\alias{spark.naiveBayes}
\alias{spark.naiveBayes,SparkDataFrame,formula-method}
\alias{write.ml,NaiveBayesModel,character-method}
\title{Naive Bayes Models}
\usage{
spark.naiveBayes(data, formula, ...)

\S4method{predict}{NaiveBayesModel}(object, newData)

\S4method{summary}{NaiveBayesModel}(object)

\S4method{spark.naiveBayes}{SparkDataFrame,formula}(data, formula,
  smoothing = 1)

\S4method{write.ml}{NaiveBayesModel,character}(object, path,
  overwrite = FALSE)
}
\arguments{
\item{data}{a \code{SparkDataFrame} of observations and labels for model fitting.}

\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', '.', ':', '+', and '-'.}

\item{...}{additional argument(s) passed to the method. Currently only \code{smoothing}.}

\item{object}{a naive Bayes model fitted by \code{spark.naiveBayes}.}

\item{newData}{a SparkDataFrame for testing.}

\item{smoothing}{smoothing parameter.}

\item{path}{the directory where the model is saved.}

\item{overwrite}{overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}
}
\value{
\code{predict} returns a SparkDataFrame containing predicted labeled in a column named
"prediction".

\code{summary} returns summary information of the fitted model, which is a list.
        The list includes \code{apriori} (the label distribution) and
        \code{tables} (conditional probabilities given the target label).

\code{spark.naiveBayes} returns a fitted naive Bayes model.
}
\description{
\code{spark.naiveBayes} fits a Bernoulli naive Bayes model against a SparkDataFrame.
Users can call \code{summary} to print a summary of the fitted model, \code{predict} to make
predictions on new data, and \code{write.ml}/\code{read.ml} to save/load fitted models.
Only categorical data is supported.
}
\note{
predict(NaiveBayesModel) since 2.0.0

summary(NaiveBayesModel) since 2.0.0

spark.naiveBayes since 2.0.0

write.ml(NaiveBayesModel, character) since 2.0.0
}
\examples{
\dontrun{
data <- as.data.frame(UCBAdmissions)
df <- createDataFrame(data)

# fit a Bernoulli naive Bayes model
model <- spark.naiveBayes(df, Admit ~ Gender + Dept, smoothing = 0)

# get the summary of the model
summary(model)

# make predictions
predictions <- predict(model, df)

# save and load the model
path <- "path/to/model"
write.ml(model, path)
savedModel <- read.ml(path)
summary(savedModel)
}
}
\seealso{
e1071: \url{https://cran.r-project.org/package=e1071}

\link{write.ml}
}
