% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{percent_rank}
\alias{percent_rank}
\alias{percent_rank}
\alias{percent_rank,missing-method}
\title{percent_rank}
\usage{
percent_rank(x = "missing")

\S4method{percent_rank}{missing}()
}
\arguments{
\item{x}{empty. Should be used with no argument.}
}
\description{
Window function: returns the relative rank (i.e. percentile) of rows within a window partition.
}
\details{
This is computed by:

(rank of row in its partition - 1) / (number of rows in the partition - 1)

This is equivalent to the PERCENT_RANK function in SQL.
}
\note{
percent_rank since 1.6.0
}
\examples{
\dontrun{
  df <- createDataFrame(mtcars)
  ws <- orderBy(windowPartitionBy("am"), "hp")
  out <- select(df, over(percent_rank(), ws), df$hp, df$am)
}
}
\seealso{
Other window_funcs: \code{\link{cume_dist}},
  \code{\link{dense_rank}}, \code{\link{lag}},
  \code{\link{lead}}, \code{\link{ntile}},
  \code{\link{rank}}, \code{\link{row_number}}
}
