% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{bround}
\alias{bround}
\alias{bround}
\alias{bround,Column-method}
\title{bround}
\usage{
bround(x, ...)

\S4method{bround}{Column}(x, scale = 0)
}
\arguments{
\item{x}{Column to compute on.}

\item{...}{further arguments to be passed to or from other methods.}

\item{scale}{round to \code{scale} digits to the right of the decimal point when \code{scale} > 0,
the nearest even number when \code{scale} = 0, and \code{scale} digits to the left
of the decimal point when \code{scale} < 0.}
}
\description{
Returns the value of the column \code{e} rounded to \code{scale} decimal places using HALF_EVEN rounding
mode if \code{scale} >= 0 or at integer part when \code{scale} < 0.
Also known as Gaussian rounding or bankers' rounding that rounds to the nearest even number.
bround(2.5, 0) = 2, bround(3.5, 0) = 4.
}
\note{
bround since 2.0.0
}
\examples{
\dontrun{bround(df$c, 0)}
}
\seealso{
Other math_funcs: \code{\link{acos}}, \code{\link{asin}},
  \code{\link{atan2}}, \code{\link{atan}},
  \code{\link{bin}}, \code{\link{cbrt}},
  \code{\link{ceil}}, \code{\link{conv}},
  \code{\link{corr}}, \code{\link{cosh}},
  \code{\link{cos}}, \code{\link{covar_pop}},
  \code{\link{cov}}, \code{\link{expm1}},
  \code{\link{exp}}, \code{\link{factorial}},
  \code{\link{floor}}, \code{\link{hex}},
  \code{\link{hypot}}, \code{\link{log10}},
  \code{\link{log1p}}, \code{\link{log2}},
  \code{\link{log}}, \code{\link{pmod}},
  \code{\link{rint}}, \code{\link{round}},
  \code{\link{shiftLeft}},
  \code{\link{shiftRightUnsigned}},
  \code{\link{shiftRight}}, \code{\link{signum}},
  \code{\link{sinh}}, \code{\link{sin}},
  \code{\link{sqrt}}, \code{\link{tanh}},
  \code{\link{tan}}, \code{\link{toDegrees}},
  \code{\link{toRadians}}, \code{\link{unhex}}
}
