% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_SpaTopic_input.R
\name{Seurat5obj_to_SpaTopic}
\alias{Seurat5obj_to_SpaTopic}
\title{Convert a Seurat v5 object as the input of 'SpaTopic'}
\usage{
Seurat5obj_to_SpaTopic(object, group.by, image = "image1")
}
\arguments{
\item{object}{Seurat v5 object}

\item{group.by}{\code{character}. The name of the column that contains celltype information in the Seurat object.}

\item{image}{\code{character}. The name of the image. Default is "image1".}
}
\value{
Return a data frame as the input of 'SpaTopic'
}
\description{
Prepare 'SpaTopic' input from one Seurat v5 object
}
\examples{

## nano.obj is a Seurat v5 object
#dataset<-Seurat5obj_to_SpaTopic(object = nano.obj, 
#                 group.by = "predicted.annotation.l1",image = "image1")
## Expect output
data("lung5")

}
\seealso{
\code{\link{lung5}}
}
