% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc-methods.R
\docType{methods}
\name{paddedFloatToChar}
\alias{paddedFloatToChar}
\title{Convert numeric to character with padding}
\usage{
paddedFloatToChar(x, padL = ceiling(log10(x + 1)), padR = 3, pad = "0")
}
\arguments{
\item{x}{numeric. Number to be converted to character with padding}

\item{padL}{numeric. Desired number of digits on left side of decimal.
             If not enough, \code{pad} will be used to pad.}

\item{padR}{numeric. Desired number of digits on right side of decimal.
             If not enough, \code{pad} will be used to pad.}

\item{pad}{character to use as padding (\code{nchar(pad)==1} must be \code{TRUE}).
           Passed to \code{\link[stringr]{str_pad}}}
}
\value{
Character string representing the filename.
}
\description{
Convert numeric to character with padding
}
\examples{
paddedFloatToChar(1.25)
paddedFloatToChar(1.25, padL=3, padR=5)
}
\author{
Eliot McIntire and Alex Chubaty
}

