% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{randomPolygons}
\alias{randomPolygons}
\title{randomPolygons}
\usage{
randomPolygons(ras = raster(extent(0, 15, 0, 15), res = 1, vals = 0),
  numTypes = 2, ...)
}
\arguments{
\item{ras}{A raster that whose extent will be used for the randomPolygons}

\item{numTypes}{Numeric value. The number of unique polygon types to use.}

\item{...}{Other arguments passed to spread. No known uses currently.}
}
\value{
A map of extent \code{ext} with random polygons.
}
\description{
Produces a raster of random polygons.
These are built with the \code{\link{spread}} function internally.
}
\examples{
library(quickPlot)

set.seed(1234)
Ras <- randomPolygons(numTypes = 5)
if (interactive()) {
  clearPlot()
  Plot(Ras, cols = c("yellow", "dark green", "blue", "dark red"))
}

library(raster)
# more complex patterning, with a range of patch sizes
a <- randomPolygons(numTypes = 400, raster(extent(0, 50, 0, 50), res = 1, vals = 0))
a[a<320] <- 0
a[a>=320] <- 1
suppressWarnings(clumped <- clump(a)) # warning sometimes occurs, but not important
aHist <- hist(table(getValues(clumped)), plot = FALSE)
if (interactive()) {
  clearPlot()
  Plot(a)
  Plot(aHist)
}

}
\seealso{
\code{\link{spread}} and \code{\link{raster}}
}
