% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heading.R
\docType{methods}
\name{heading}
\alias{heading}
\alias{heading,SpatialPoints,SpatialPoints-method}
\alias{heading,matrix,matrix-method}
\alias{heading,matrix,SpatialPoints-method}
\alias{heading,SpatialPoints,matrix-method}
\title{Heading between spatial points.}
\usage{
heading(from, to)

\S4method{heading}{SpatialPoints,SpatialPoints}(from, to)

\S4method{heading}{matrix,matrix}(from, to)

\S4method{heading}{matrix,SpatialPoints}(from, to)

\S4method{heading}{SpatialPoints,matrix}(from, to)
}
\arguments{
\item{from}{The starting position; an object of class SpatialPoints.}

\item{to}{The ending position;  an object of class SpatialPoints.}
}
\value{
The heading between the points, in degrees.
}
\description{
Determines the heading between spatial points.
}
\examples{
library(sp)
N <- 10L                # number of agents
x1 <- stats::runif(N, -50, 50) # previous X location
y1 <- stats::runif(N, -50, 50) # previous Y location
x0 <- stats::rnorm(N, x1, 5)   # current X location
y0 <- stats::rnorm(N, y1, 5)   # current Y location

# using SpatialPoints
prev <- SpatialPoints(cbind(x = x1, y = y1))
curr <- SpatialPoints(cbind(x = x0, y = y0))
heading(prev, curr)

# using matrix
prev <- matrix(c(x1, y1), ncol = 2, dimnames = list(NULL, c("x","y")))
curr <- matrix(c(x0, y0), ncol = 2, dimnames = list(NULL, c("x","y")))
heading(prev, curr)

#using both
prev <- SpatialPoints(cbind(x = x1, y = y1))
curr <- matrix(c(x0, y0), ncol = 2, dimnames = list(NULL, c("x","y")))
heading(prev, curr)

prev <- matrix(c(x1, y1), ncol = 2, dimnames = list(NULL, c("x","y")))
curr <- SpatialPoints(cbind(x = x0, y = y0))
heading(prev, curr)

}
\author{
Eliot McIntire
}
