% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/youth_get_sojourns.R
\name{get_youth_sojourns}
\alias{get_youth_sojourns}
\title{Label Sojourns in a data stream according to the youth-specific algorithm}
\usage{
get_youth_sojourns(
  vm,
  short = 30,
  Output = c("Counts", "Raw"),
  Site = c("Hip", "Wrist"),
  epoch = 1,
  difference = 15,
  threshold = 100,
  verbose = FALSE
)
}
\arguments{
\item{vm}{vector of triaxial accelerometer values, either the vector
magnitude for activity counts, or the Euclidian Norm Minus One for raw
acceleration}

\item{short}{numeric scalar. Shortest allowable duration for a Sojourn.
Should be detected automatically from the internally-stored grid search
values for the attachment site (hip or wrist) and data type (counts or raw)}

\item{Output}{the data type (counts or raw)}

\item{Site}{the attachment site (hip or wrist)}

\item{epoch}{the epoch length, in seconds}

\item{difference}{the difference parameter}

\item{threshold}{the threshold parameter}

\item{verbose}{logical. Print processing updates to the console?}
}
\value{
A data frame (with \code{nrow} equal to \code{length(vm)}) that gives
  sojourn labels and durations
}
\description{
Identify Sojourns using the algorithm of \href{https://pubmed.ncbi.nlm.nih.gov/29135657/}{Hibbing et al. (2018)}
}
\examples{
data(example_data, package = "Sojourn")
if (isTRUE(requireNamespace("Sojourn.Data"))) {
get_youth_sojourns(example_data$Vector.Magnitude,
  Output = "Counts", Site = "Hip")
}
}
