% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dep_data}
\alias{dep_data}
\title{Scottish deprivation data}
\format{
A data frame with 1012 rows and 26 variables:
\describe{
  \item{PS_code}{postcode sector code}
  \item{PS_name}{postcode sector name}
  \item{health_board}{health board name}
  \item{council_area}{Council area name}
  \item{ur2fold}{Two-fold urban-rural classification, derived based on 2011-2012 Scottish Government
  urban-rural classification for output areas. Used in this data set for illustration only.}
  \item{total_pop}{Number of people in postcode sector}
  \item{pcnt_overcrowding}{Percent of people living in overcrowded households}
  \item{pcnt_male_unemp}{Percent of unemployed men}
  \item{pcnt_no_car}{Percent of people in households with no access to a car/van}
  \item{pcnt_low_class}{Percent of people in low social class}
  \item{carstairs}{The 2011 Carstairs score}
  \item{pcnt_limited_lot}{Percent of people whose day-to-day activities are limited a lot}
  \item{pcnt_no_llti}{Percent of people whose day-to-day activities are not limited}
  \item{pcnt_bad_health}{Percent of people in bad or very bad health}
  \item{pcnt_good_health}{Percent of people in good or very good health}
  \item{quintile}{Quintiles of the Carstairs score; 1 - least deprived, 5 - most deprived}
  \item{decile}{Deciles of the Carstairs score; 1 - least deprived, 10 - most deprived}
  \item{good_health}{Number of people in very good and good health}
  \item{fair_health}{Number of people in fair health}
  \item{bad_health}{Number of people in bad or very bad health}
}
}
\source{
For Carstairs deprivation data look at
 \url{http://www.sphsu.mrc.ac.uk/carstairs_2011_report_final_v3_-update-06-16-.pdf}

Self-rated health data are from the 2011 census \url{http://www.scotlandscensus.gov.uk/}
}
\usage{
dep_data
}
\description{
The data set provides the Carstairs deprivation scores, deciles, quintiles and individual Carstairs score
variables for Scottish postcode sectors in 2011. A few self-rated health variables from the 2011 Scottish
Census are also provided.
}
\keyword{datasets}
