% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeIntegration.R
\name{timeIntegration}
\alias{timeIntegration}
\title{Approximate the integral of a vector of data over time}
\usage{
timeIntegration(data, time = names(data), lower = time[1],
  upper = time[length(time)], check.plot = FALSE, units = c("hours",
  "minutes", "seconds"))
}
\arguments{
\item{data}{Vector of numerical data}

\item{time}{Vector of timestamps which correspond to \code{data}. These can
either character or POSIXct.}

\item{lower}{The time (character or POSIXct) of the lower bound of the
integration}

\item{upper}{The time (character or POSIXct) of the upper bound of the
integration}

\item{check.plot}{\code{=TRUE} makes a plot which illustrates the
integration.}

\item{units}{The units of integration, defaults to hours.  It is only
required to supply enough characters to uniquely complete the name.}
}
\value{
The approximation of the integral by joining the points in the
series in a linear fashion and calculating the area under this "curve".
}
\description{
Integrate a series over time by calculating the area under the "curve" of
the linear interpolation of the series (akin to the Trapezoid rule).
This is especially useful in calculating
energy usage: kilowatt-hours, watt-seconds, etc.
}
\details{
If \code{upper} or \code{lower} does not correspond to a data point, a
linear interpolation is made between the two neighboring time points to
predict the resulting data value.
}
\examples{
# Some example power data
data(PowerData)

par(mfrow = c(2, 1))

# Calculate the kilowatt-minutes, display graph which shows how the
# integration is done.  This example calculates the integral using
# a contiguous subset of the data
int1 <- timeIntegration(PowerData,
                       # Convert to POSIXct in order to subtract time
                       lower = "5/6/2008 17:00:09",
                       upper = "5/6/2008 17:01:36",
                       check.plot = TRUE, units = "m")

# This example calculates the integral for all the data in 'powerData'
int2 <- timeIntegration(PowerData, check.plot = TRUE, units = "m")

# Print the outcome
pvar(int1, int2)
}
\author{
Landon Sego
}
\keyword{misc}
