% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RoundViaDummy.R
\name{ModelMatrix}
\alias{ModelMatrix}
\title{Overparameterized model matrix}
\usage{
ModelMatrix(
  formula,
  data = NULL,
  mf = model.frame(formula, data = data),
  allFactor = TRUE,
  sparse = FALSE,
  formulaSums = FALSE,
  printInc = FALSE
)
}
\arguments{
\item{formula}{formula}

\item{data}{data frame}

\item{mf}{model frame (alternative input instead of data)}

\item{allFactor}{When TRUE all variables are coerced to factor}

\item{sparse}{When TRUE sparse matrix created by sparse.model.matrix()}

\item{formulaSums}{When TRUE, sparse matrix via FormulaSums()}

\item{printInc}{Printing \code{...} to console when TRUE}
}
\value{
model matrix created via model.matrix(), sparse.model.matrix() or FormulaSums()
}
\description{
All factor levels included
}
\examples{
  z1 <- SmallCountData("z1")
  ModelMatrix(~region*hovedint,z1)
}
\keyword{internal}
