% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_SlidingWindows.R
\name{dmc_SlidingWindows}
\alias{dmc_SlidingWindows}
\title{Detrended Multiple Cross-Correlation Coefficient with sliding windows.}
\usage{
dmc_SlidingWindows(x1, x2, y, w, k, nu)
}
\arguments{
\item{x1}{A vector contaning univariate time series.}

\item{x2}{A vector contaning univariate time series.}

\item{y}{A vector contaning univariate time series.}

\item{w}{An integer value indicating the size of the window \eqn{w < length(y)}.
If \eqn{w = length(y)}, will be computed the function will not slide.}

\item{k}{An integer value indicating the boundary of the division \eqn{(N/k)}.
The smallest value of \eqn{k} is \eqn{4}.}

\item{nu}{An integer value. See the DCCA package.}
}
\value{
A list contaning "w", "dmc", "rhodcca_yx1", "rhodcca_yx2", "rhodcca_x1x2".
}
\description{
This function generates Detrended Cross-Correlation Coefficient of
three time series with sliding windows approach.
}
\details{
This function include following measures:

    w, timescale, dmc, rhodcca_yx1, rhodcca_yx2, rhodcca_x1x2
}
\examples{
x1 <- rnorm(100)
x2 <- rnorm(100)
y <- rnorm(100)
dmc_SlidingWindows(x1,x2,y,w=99,k=10,nu=0)

}
\references{
ZEBENDE, G.F.; SILVA-FILHO, A.M. Detrended Multiple Cross-Correlation Coefficient. PHYSICA A, v.510, p.91-97, 2018. doi = "https://doi.org/10.1016/j.physa.2018.06.119".
}
