% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Alt_Alg_discont.R
\name{Alt_Alg_discont}
\alias{Alt_Alg_discont}
\title{Application of Alt_Alg to discontinuous data}
\usage{
Alt_Alg_discont(Overall_name,Names, t_all, X_all, Y_all, R, s = 10, m = 500, save = 'n')
}
\arguments{
\item{Overall_name}{name for the set of separate trajectories}

\item{Names}{list of names for each trajectory}

\item{t_all}{list of arrays, one for each trajectory of times when the positions were recorded}

\item{X_all}{list of arrays, one for each trajectory of x-coordinates}

\item{Y_all}{list of arrays, one for each trajectory of y-coordinates}

\item{R}{radius value to use}

\item{s}{number of time steps between checks for entrances and exits}

\item{m}{estimate of the maximum number of crossings across all circles}

\item{save}{if \code{'y'}, save the files}
}
\description{
Calculates the residence times from discontinuous data, which can then be used to identify sites of interest. This could also be used to identify sites for a group of animals, by treating each animal's trajectory as one segment of a discontinuous set.
}
\details{
This function is used specifically with discontinuous data to calculate the residence times for the trajectories. It works in the same way as for \code{\link{Alt_Alg}}, by linking together \code{\link{Alt_Alg_mini}} and \code{\link{combining}}.
}
\examples{
##Find the current working directory
wd = getwd()
##Set the working directory as the temporary one
setwd(tempdir())
##Load the data
data(OU_14)
t=unlist(OU_14["t"])
X=unlist(OU_14["X"])
Y=unlist(OU_14["Y"])

##Number of path sections
n=5
##Number of recorded locations
N = length(t)

##A list of arrays of the time recoding for the 3 of the trajectory segments
t_all = list(t[seq(1,floor(N/n))], t[seq(floor(N/n)*2,floor(N/n)*3)], 
t[seq(floor(N/n)*4,floor(N/n)*5)])

##A list of arrays of the x-coordinates for the 3 of the trajectory segments
X_all = list(X[seq(1,floor(N/n))], X[seq(floor(N/n)*2,floor(N/n)*3)], 
X[seq(floor(N/n)*4,floor(N/n)*5)])

##A list of arrays of the y-coordinates for the 3 of the trajectory segments
Y_all = list(Y[seq(1,floor(N/n))], Y[seq(floor(N/n)*2,floor(N/n)*3)], 
Y[seq(floor(N/n)*4,floor(N/n)*5)])

##The calculation of the residence time for discontibuous data
Alt_Alg_discont("OU_14_discont",c("OU_14.1","OU_14.3","OU14.5"),t_all,X_all,Y_all,0.3,save='y')

##Reset the original working directory
setwd(wd)
}
\references{
Munden, R., Borger , L., Wilson, R.P., Redcliffe, J., Loison, A., Garel, M. and Potts, J.P. in review. Making sense of ultra-high-resolution movement data: an algorithm for inferring sites of interest.
}
\seealso{
See also \code{\link{Alt_Alg}} for the algorithim used on continuous data. \code{\link{Alt_Alg_mini}} is used to calculate the residence times for a particular set of circles and a particular trajectory, then using \code{\link{combining}} all the residence times for the same circles are summed.
}
\author{
Rhys Munden <rdmunden1@sheffield.ac.uk>
}
\keyword{Discontinuous}
