% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LifeSim_Functions.R
\name{sim_life}
\alias{sim_life}
\title{Simulate all life events}
\usage{
sim_life(hazard_rates, GRR, carrier_prob, RV_status, YOB, stop_year,
  NB_params = c(2, 4/7), fert = 1, birth_range = NULL)
}
\arguments{
\item{hazard_rates}{An object of class \code{hazard}, created by \code{\link{hazard}}.}

\item{GRR}{Numeric. The genetic relative-risk of disease, i.e. the relative-risk of disease for individuals who carry at least one copy of the causal variant.}

\item{carrier_prob}{Numeric.  The carrier probability for all causal variants with relative-risk of disease \code{GRR}.  By default, \code{carrier_prob}\code{ = 0.002}}

\item{RV_status}{Numeric. \code{RV_status = TRUE} if the individual is a carrier of a rare variant that increases disease suseptibility, and \code{FALSE} otherwise.}

\item{YOB}{A positive number. The indivdiual's year of birth.}

\item{stop_year}{Numeric. The last year of study.  If not supplied, defaults to the current year.}

\item{NB_params}{Numeric vector of length 2. The size and probability parameters of the negative binomial distribution used to model the number of children per household.  By default, \code{NB_params}\code{ = c(2, 4/7)}, due to the investigation of Kojima and Kelleher (1962).}

\item{fert}{Numeric.  A constant used to rescale the fertility rate after disease-onset. By default, \code{fert = 1}.}

\item{birth_range}{This argument is depreciated.}
}
\value{
A named matrix containing the years of an individual's simulated life events, named by event type, see details.
}
\description{
Primarily intended as an internal function, \code{sim_life} simulates all life events for an individual starting at birth, age 0, and ending with death or the end of the study.
}
\details{
Starting at birth, age 0, \code{sim_life} generates waiting times to reproduction, onset, and death. The event with the shortest waiting time is chosen as the next life event, and the individual's age is updated by the waiting time of the winning event.  Conditioned on the individual's new age, this process is applied recursively, until death or until the end of the study is reached.

We make the following assumptions regarding the simulation of waiting times:
 \enumerate{
 \item We assume that, given an individual's current age, their time to disease onset is the waiting time in a non-homogeneous Poisson process with an age-specific hazard rate that follows a proportional hazards model.  In this model, individuals who have NOT inherited the rare variant experience disease onset according to the baseline (or population) hazard rate of disease.  On the other hand, individuals who have inherited the rare variant are assumed to have an increased risk of disease onset relative to those who have inherited it.  The user is expected to supply the baseline hazard rate of disease, as well as the relative-risk of disease for genetic cases. Additionally, we impose the restriction that individuals may only experience disease onset once, and remain affected from that point on.

\item We assume that, given an individual's current age, their time to death is the waiting time in a non-homogeneous Poisson process with age-specific hazard rate determined by their affection status.  We assume that disease-affected individuals experience death according to the age-specific hazard rate for death in the \emph{affected} population.  On the other hand, we assume that \emph{unaffected} individuals experience death according to the age-specific hazard rate for death in the \emph{unaffected} population.  If the disease of interest is sufficiently rare, the user may choose to substitute the \emph{population} age-specific hazard rate for death for the aforementioned age-specific hazard rate for death in the \emph{unaffected} population.  The user is expected to supply age-specific hazard rates of death for both the \emph{affected} and \emph{unaffected} populations.

\item We assume that, given an individual's current age, their time to reproduction is the waiting time in a homogeneous Poisson process.  That is, we assume that individuals reproduce at uniform rate during their reproductive years.  For example, one's reproductive years may span from age 20 to age 35 years.  To mimic observed age-specific fertility data, the birth range for an individual is simulated as follows: first we sample the lower bound uniformly from ages 16 to 27, next we sample the range of the birth span uniformly from 10 to 18 years and add this value to the lower bound to determine the upper bound of the birth range.  We do not allow for offspring to be produced outside of an individual's simulated reproductive birth span.
 }

\code{sim_life} will return a named matrix, which contains the years of the simulated life events, named by event type.  The possible event types are as follows:
\itemize{
 \item "Child" a reproductive event, i.e. creation of offspring
 \item "Onset" disease onset event,
 \item "Death" death event
}
}
\examples{
data(AgeSpecific_Hazards)
my_HR <- hazard(hazardDF = AgeSpecific_Hazards)

# The following commands simulate all life events for an individual, who
# has NOT inherited a causal variant, born in 1900.  From the output, this
# individual has two children, one in 1921 and another in 1923, and then
# dies in 1987.
set.seed(135)
sim_life(hazard_rates = my_HR, GRR = 10,
         carrier_prob = 0.002,
         RV_status = FALSE,
         YOB = 1900, stop_year = 2000)

# Using the same random seed, notice how life events can vary for
# someone who has inherited the causal variant, which carries a
# relative-risk of 10. From the output, this individual also has
# two children, but then experiences disease onset in 1974,
# and dies in 1976.
set.seed(135)
sim_life(hazard_rates = my_HR, GRR = 10,
               carrier_prob = 0.002,
               RV_status = TRUE,
               YOB = 1900, stop_year = 2000)

}
\references{
Nieuwoudt, Christina and Jones, Samantha J and Brooks-Wilson, Angela and Graham, Jinko. (14 December 2017) \emph{Simulating Pedigrees Ascertained for Multiple Disease-Affected Relatives}. bioRxiv 234153.

Ken-Ichi Kojima, Therese M. Kelleher. (1962), \emph{Survival of Mutant Genes}. The American Naturalist 96, 329-346.
}
