% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlatedpheno.R
\name{build.cor.phe}
\alias{build.cor.phe}
\title{Build correlated phenotypes}
\usage{
build.cor.phe(pheno, corMtr, sdMtr = NULL, margin = 2, ...)
}
\arguments{
\item{pheno}{a matrix or dataframe with the phenotypic information.}

\item{corMtr}{a correlation matrix.}

\item{sdMtr}{a matrix with the standard deviation,
e.g., if the number of dimensions is 2, then it is
\eqn{\left(\begin{array}{cc} \sigma_{1} & 0 \\ 0 & \sigma_{2} \end{array}\right)}.
If it is NULL (default), generate it based on the data from \code{pheno}.}

\item{margin}{a vector giving the subscript which the function will be
applied over.
E.g., for a matrix 1 indicates rows, 2 (default) indicates columns.
Where \code{pheno} has named dimnames, it can be a character vector selecting
dimension names.}

\item{...}{not used.}
}
\value{
a matrix with correlated phenotypes.
}
\description{
Build correlated phenotypes
}
\examples{
x1 <- rnorm(4000, mean = 5, sd = 10)
x2 <- rnorm(4000, mean = 10, sd = 30)
x <- matrix(cbind(x1, x2), ncol = 2)

# test original correlation
cor.test(x[, 1], x[, 2])

# correlation matrix
corM <- matrix(c(1, 0.6, 0.6, 1), ncol = 2)

# standard deviation matrix
sdM <- matrix(c(10, 0, 0, 30), ncol = 2)

# build correlation
x.new <- build.cor.phe(x, corM, sdM)

# check mean and standard deviation of new data set
apply(x.new, 2, mean)
apply(x.new, 2, sd)

# test correlation
cor.test(x.new[, 1], x.new[, 2])
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de}
}

