\name{haplo.surv}
\alias{haplo.surv}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Haplotype analysis for survival data}
\description{
\code{haplo.surv} performs a series of Cox proportional hazards models to survival data with haplotypes using a simulation-based approach to account for uncertainty in haplotype assignment when phase is unknown. 
}
\usage{
haplo.surv(formula1, formula2, pheno, haplo, sim, effect = "add", 
	sub = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula1}{a symbolic description of the full model to be fit, including haplotype parameters. The response must be a survival object as returned by the \code{Surv} function.}
  \item{formula2}{a symbolic description of the nested model excluding haplotype parameters, to be compared to \code{formula1} in a likelihood ratio test. The response must be a survival object as returned by the \code{Surv} function.}
  \item{pheno}{a dataframe containing phenotype data.}
  \item{haplo}{a haplotype object made by \code{make.haplo.rare}.}
  \item{sim}{the number of simulations from which to evaluate the results.}
  \item{effect}{the genetic effect type: \code{"add"} for additive, \code{"dom"} for dominant and \code{"rec"} for recessive. Defaults to additive. See note.}
  \item{sub}{optional. An expression using a binary operator, representing a subset of individuals on which to perform analysis. e.g. \code{sub=expression(sex==1)}.}
}
\details{
  \code{formula1} should be in the form of \code{response ~ predictor(s) + haplotype(s)} and \code{formula2} should be in the form \code{response ~ predictor(s)}. A formula has an implied intercept term. See documentation for the \code{formula} function for more details of allowed formulae.
}
\value{
\code{haplo.surv} returns an object of 'class' \code{hapSurv}.

     The \code{summary} function can be used to obtain and print a
     summary of the results.  

     An object of class \code{hapSurv} is a list containing the
     following components:
     
  \item{formula1}{\code{formula1} passed to \code{haplo.surv}.}
  \item{formula2}{\code{formula2} passed to \code{haplo.surv}.}
  \item{results}{a table containing the hazard ratios, confidence intervals and p-values of the parameter estimates, averaged over the n=\code{sim} models performed.}
  \item{empiricalResults}{a list containing the hazard ratios, confidence intervals and p-values calculated at each simulation}
  \item{logLik}{the average log-likelihood for the n=\code{sim} linear models fit using formula1.}
  \item{LRT}{a likelihood ratio test, testing for significant improvement of the model when haplotypic parameters are included}
  \item{predicted}{estimated marginal means of the outcome variable broken down by haplotype levels, evaluated at mean values of the model predictors, averaged over all simulations.}
  \item{ANOVA}{analysis of variance, comparing the two models fit with and without haplotypic parameters.}
  \item{Wald}{The Wald test for overall significance of the fitted model including haplotypes.}
  \item{rsquared}{r-squared values for models fit using \code{formula1} and \code{formula2}.}
  \item{effect}{the haplotypic effect modelled, `ADDITIVE', `DOMINANT' or `RECESSIVE'.}
}
\references{
Andersen, P., Gill, R. (1982) Cox's regression model for counting processes, a large sample study, \emph{Annals of Statistics}, 10:1100-1120.

Little, R.J.A., Rubin, D.B. (2002) \emph{Statistical Analysis with Missing Data}. John Wiley and Sons, New Jersey. 

McCaskie, P.A., Carter, K.W, Hazelton, M., Palmer, L.J. (2007) SimHap: A comprehensive modeling framework for epidemiological outcomes and a multiple imputation approach to haplotypic analysis of population-based data, [online] www.genepi.org.au/simhap.

Rubin, D.B. (1996) Multiple imputation after 18+ years (with discussion). \emph{Journal of the American Statistical Society}, 91:473-489.

Therneau, T., Grambsch, P., Fleming, T. Martingale based residuals for survival models,  \emph{Biometrika}, 77(1):147-160.
}
\author{Pamela A. McCaskie}
\note{
To model a codominant haplotypic effect, define the desired haplotype as a factor in the \code{formula1} argument. e.g. \code{factor(h.AAA)}, and use the default option for \code{effect}.
}
\seealso{\code{\link{snp.surv}}, \code{\link{haplo.bin}}, \code{\link{haplo.quant}}, \code{\link{haplo.long}}}
\examples{

data(SNPsurv.dat)

# convert SNP.dat to format required by infer.haplos
survHaplo.dat <- SNP2Haplo(SNPsurv.dat)

data(survPheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(survHaplo.dat) 

# print haplotype frequencies generated by infer.haplos
myinfer$hap.freq 

# generate haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05)

mymodel <- haplo.surv(formula1=Surv(time, status)~age+h.V1AA, 
	formula2=Surv(time, status)~age, haplo=myhaplo, 
	pheno=survPheno.dat, sim=10)
summary(mymodel)

# example using a subsetting variable - looking at males only
mymodel <- haplo.surv(formula1=Surv(time, status)~age+h.V1AA, 
	formula2=Surv(time, status)~age, haplo=myhaplo, 
	pheno=survPheno.dat, sim=10, sub=expression(sex==1))
summary(mymodel)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models}

