% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimDesign.R
\docType{data}
\name{BF_sim}
\alias{BF_sim}
\title{Example simulation from Brown and Forsythe (1974)}
\description{
Example results from the Brown and Forsythe (1974) article on robust estimators for
variance ratio tests. Statistical tests are organized by columns and the unique design conditions
are organized by rows. See \code{\link{BF_sim_alternative}} for an alternative form of the same
simulation. Code for this simulation is available of the wiki
(\url{https://github.com/philchalmers/SimDesign/wiki}).
}
\examples{

\dontrun{
data(BF_sim)
head(BF_sim)

#Type I errors
subset(BF_sim, var_ratio == 1)
}
}
\references{
Brown, M. B. and Forsythe, A. B. (1974). Robust tests for the equality of variances.
  \emph{Journal of the American Statistical Association, 69}(346), 364--367.

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{data}
